# Packet Sniffer IOT/Device Bridge

This repository contains a Python script for packet sniffing. The script is designed to run on an IoT/Device bridge, capturing network packets and sending them to a specified server. The configuration for the script is provided in the `configs.json` file.

## Getting Started

### Dependencies

- Python 3  
- Kafka-python  
- Cython  

### Configuration

See configs.json as an example and edit it to match your needs. Here's an example configuration:

- bootstrap_servers: The Kafka bootstrap servers to connect to.
- topic: The Kafka topic to publish the sniffed packets.
- interface: The network interface to sniff packets from.
- log_file: The path to the log file for capturing logs.
- agent_bindings: The path to the file containing MAC addresses configurations.
- identifier: This the identifier for agent bindings and also to extract outbound packets. It should be src_mac(mac addresses) and src (ipv4 addresses) 


### Build guide for Cython
```
pip install -r requirements.txt
pip install cython  
cython --embed -o sniffer.c sniffer.py  
gcc -Os -I /usr/include/python3.8/ sniffer.c -lpython3.8 -o profiler_sniffer
```

### Build guide for Cython Arm based
```
pip install -r requirements.txt
sudo apt install cython3
cython3 --embed -o sniffer.c sniffer.py
gcc -Os -I /usr/include/python3.8/ sniffer.c -lpython3.8 -o profiler_sniffer
```

### Usage

Run the cythonize file using:
```
sudo ./profiler_sniffer
```


## Who to talk to
Name: Abdul Samad  
Email: abdul.samad@ebryx.com  
Department: Custom Engineering