var express = require('express');
var expressJWT = require('express-jwt');
var path = require('path');
var favicon = require('serve-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');
require('dotenv').config({path: '/var/local/env/apiPortal'});
var cors = require('cors');
var blacklist = require('express-jwt-blacklist');
const expressSanitizer = require('express-sanitizer');

process.env.NODE_TLS_REJECT_UNAUTHORIZED='0';

process.env.NODE_TLS_REJECT_UNAUTHORIZED='0';

var apiFolder = 'api/';
var apiBasePath = '/api';

var models = require('./models');
var gauth = require('./routes/' + apiFolder + 'gauth');
var idps = require('./routes/' + apiFolder + 'idps');
var clientRoutes = require('./routes/api/client');
const webRoutes = require('./routes/webpages');
var entitlementsRoutes = require('./routes/api/entitlements');
var apiUserRoutes = require('./routes/api/apiUser')
var softwareValidationRoutes = require('./routes/api/softwareValidation');
var publicApi = require('./routes/api/publicApi');
var riskScoreRoute = require('./routes/api/riskScore')
var eventRoute = require('./routes/api/event')

var app = express();

app.set('views', path.join(__dirname, '/views'));
app.set('view engine', 'ejs');
app.use('/', webRoutes);
app.use(cors());
app.use(cookieParser());
app.use(logger('dev'));

app.use(bodyParser.json({limit: '400mb'}));
app.use(bodyParser.urlencoded({extended: false}));
app.use(expressSanitizer());

app.set('views', path.join(__dirname, '/views'));
app.set('view engine', 'ejs');

app.use((req, res, next) => {
    if (req.cookies.token) {
        console.log(req.cookies.token);
        req.headers.authorization = `Bearer ${req.cookies.token}`;
    }

    next();
});

app.use((req, res, next) => {
    res.setHeader('Cache-Control', 'no-cache, no-store, must-revalidate'); // HTTP 1.1.
    res.setHeader('Pragma', 'no-cache'); // HTTP 1.0.
    next();
});

app.use(
    expressJWT({
        secret: process.env.JWT_SECRET_KEY,
        isRevoked: blacklist.isRevoked
    }).unless({
        path: [
            '/api/clients/bridge/detail',
            '/api/clients/bridge/slaveDetail',
            '/api/clients/riskScore',
            '/api/clients/event',
            '/api/clients/bridge/resetPasswordRequest',
            '/api/clients/bridge/resetPassword',
            '/api/clients/verify/otp',
            '/api/entitlements/createEntitlement',
            '/api/entitlements/deleteEntitlement',
            '/api/apiUser/forgotPassword',
            '/api/riskScore/device',
            '/api/riskScore/user',
            /\/api\/event*/,
            '/api/softwareValidation/validate',
            '/api/publicApi/sessionKey',
            /\/api\/gauth*/,
            /\/api\/onboard*/,
            /\/api\/enhanced\-onboard*/,
            '/',
            '/favicon.ico'
        ]
    })
);

app.use(apiBasePath + '/gauth', gauth);
app.use(apiBasePath + '/idps', idps);
app.use(apiBasePath + '/clients', clientRoutes);
app.use(apiBasePath + '/entitlements', entitlementsRoutes);
app.use(apiBasePath + '/apiUser', apiUserRoutes)
app.use(apiBasePath + '/publicApi', publicApi);
app.use(apiBasePath + '/softwareValidation', softwareValidationRoutes);
app.use(apiBasePath + '/riskScore', riskScoreRoute);
app.use(apiBasePath + '/event', eventRoute);
//app.use(apiBasePath + '/enhanced-onboard', enhancedOnboard);

// catch 404 and forward to error handler
app.use(function (req, res, next) {
    var err = new Error('Not Found');
    err.statusCode = 404;
    next(err);
});

// error handler
app.use(function (err, req, res, next) {
    let code = err.statusCode || 500;

    if (err.name && err.name === 'UnauthorizedError') {
        code = 403;
    }

    if (code === 500) {
        console.error(err.stack);
    }

    res.status(code).send({message: err.message});
    // set locals, only providing error in development
    // res.locals.message = err.message;
    // res.locals.error = req.app.get('env') === 'development' ? err : {};

    // render the error page
    // res.status(err.status || 500);
    // res.render('error');
});
module.exports = app;
