const redis = require('redis');
const util = require('util');

const client = redis.createClient({
  host: process.env.REDIS_HOST || '127.0.0.1',
  port: process.env.REDIS_PORT || '6379',
  password: process.env.REDIS_PASSWORD || undefined,
  prefix: "invisily:",
  enable_offline_queue: false,
  retry_strategy: function(options) {
    console.error('Redis connection error: ', (options.error || {}).message);
    console.log(`Retry connection to redis in ${Math.min(options.attempt * 5, 60)}s`);
    return Math.min(options.attempt * 5000, 60000);
  }
});

client.on("connect", function(error) {
  console.log('Redis Connected.');
});

client.on("end", function(error) {
  console.error('Redis connection lost.');
});

client.on("reconnecting", function(error) {
  console.log('Redis connection reconnecting.');
});

client.on("ready", function(error) {
  console.log('Redis connection ready.');
});

client.on("error", function(error) {
  console.error('Redis error:', error || '');
});

client.getAsync = util.promisify(client.get).bind(client);
client.setAsync = util.promisify(client.set).bind(client);
client.lrangeAsync = util.promisify(client.lrange).bind(client);
client.appendAsync = util.promisify(client.append).bind(client);
client.incrAsync = util.promisify(client.incr).bind(client);
client.incrbyAsync = util.promisify(client.incrby).bind(client);
client.decrAsync = util.promisify(client.decr).bind(client);
client.decrbyAsync = util.promisify(client.decrby).bind(client);
client.delAsync = util.promisify(client.del).bind(client);
client.keysAsync = util.promisify(client.keys).bind(client);
client.expireAsync = util.promisify(client.expire).bind(client);
client.ttlAsync = util.promisify(client.ttl).bind(client);
client.strlenAsync = util.promisify(client.strlen).bind(client);
client.publishAsync = util.promisify(client.publish).bind(client);
client.zAddAsync = util.promisify(client.zadd).bind(client);
client.zRangeAsync = util.promisify(client.zrange).bind(client);
client.zRangeByScoreAsync = util.promisify(client.zrangebyscore).bind(client);
client.zCountAsync = util.promisify(client.zcount).bind(client);

module.exports = client;
