var dotenv = require('dotenv').config({ path: '/var/local/env/sdp' });
module.exports = {
  development: {
    database: process.env.DEV_DATABASE,
    username: process.env.DEV_USERNAME,
    password: process.env.DEV_PASSWORD,
    host: process.env.DEV_HOST,
    dialect: 'mysql',
    logging: process.env.NODE_ENV === 'production' ? false : msg => console.log(msg),
    pool: {
      max: 100,
      min: 0,
      // @note https://github.com/sequelize/sequelize/issues/8133#issuecomment-359993057
      acquire: 100*1000,
    }
  },

  test: {
    database: process.env.TESTING_DATABASE,
    username: process.env.TESTING_USERNAME,
    password: process.env.TESTING_PASSWORD,
    host: process.env.TESTING_HOST,
    dialect: 'mysql',
    pool: {
      max: 100,
      min: 0,
      // @note https://github.com/sequelize/sequelize/issues/8133#issuecomment-359993057
      acquire: 100*1000,
    }
  },

  production: {
    database: process.env.PRODUCTION_DATABASE,
    username: process.env.PRODUCTION_USERNAME,
    password: process.env.PRODUCTION_PASSWORD,
    host: process.env.PRODUCTION_HOST,
    dialect: 'mysql',
    logging: process.env.NODE_ENV === 'production' ? false : msg => console.log(msg),
    pool: {
      max: 100,
      min: 0,
      // @note https://github.com/sequelize/sequelize/issues/8133#issuecomment-359993057
      acquire: 100*1000,
    }
  },
  project: {
    development: {
      onPremApiUrl: 'https://127.0.0.1:8080/api',
      offPremApiUrl: 'https://119.63.130.91:8080/api',
      offPremUiUrl: 'https://119.63.130.91:8080/web',
      onPremUiUrl: 'https://127.0.0.1:8080/web',
      serviceInstallerPath: '/var/local/installers',
      componentInstallationPath: '/var/www/html/admin-gui',
      publicIP: '119.63.130.91',
      pemPassword: 'SZNEe62D',
      clientLocalDomain: 'client.invisily.com'
    },
    production: {
      onPremApiUrl: 'https://${ON_PREM_API_IP}/api',
      offPremApiUrl: 'https://${OFF_PREM_API_IP}/api',
      onPremUiUrl: 'https://${ON_PREM_API_IP}/web',
      offPremUiUrl: 'https://${OFF_PREM_API_IP}/web',
      serviceInstallerPath: '/var/local/installers',
      componentInstallationPath: '/var/www/html/admin-gui',
      publicIP: '172.16.13.180',
      pemPassword: 'SZNEe62D',
      clientLocalDomain: 'client.invisily.com'
    }
  }
};
