const {Op} = require('sequelize');
const models = require('../models');
const adminPortalURL = `${process.env.AP_SERVER_IP}:${process.env.AP_SERVER_PORT}`;
const axios = require('axios');


const forgotPassword = async (req, res, next) => {

    try {
      const { email } = req.body;
      let admin_portal_url = `https://${adminPortalURL}/api/apiUser/sendPasswordResetEmail`;
      let payload = email;
      
      const user = await models.User.findOne({
        where: {
          email: email
        }
      });
  
      if (!user) {
        return res.status(404).json({ error: 'User not found' });
      }
  
      const userId = user.id;
      
      const userRole = await models.UserRole.findOne({
        where: {
          userId: userId
        }
      });
  
      if (!userRole) {
        return res.status(403).json({ error: 'User has no role assigned' });
      }
  
      let query = `
        SELECT DISTINCT t.id as temp_id, t.name, t.description
        FROM Templates t
        INNER JOIN TemplatePermissions tp ON tp.temp_id = t.id
        INNER JOIN Permissions p ON p.id = tp.permission_id
        INNER JOIN Privilege pv ON pv.id = p.privilege_id
        INNER JOIN UserTemplates ut ON ut.temp_permission_id = tp.id
        INNER JOIN Users u ON u.id = ut.user_id
        WHERE u.id = ${userId} AND temp_id = 6
      `;
  
      let onlyPublic = (await models.sequelize.query(query))[0];

      if(!onlyPublic[0]){
        return res.status(403).json({ error: 'User does not have the Public-Api role' });
      }

      const response = await axios.get(admin_portal_url, {
          params: {
            email: payload
          }
        });

      return res.status(200).send({
          'success': true,
          message : 'email sent',
      });
    } catch (error) {
      res.status(500).json({ error: 'Internal Server Error' });
    }
};
  
module.exports = {
  forgotPassword
};

