const {Op} = require('sequelize');
const models = require('../models');
const httpErrors = require('http-errors')
const crypto = require('crypto');
const adminPortalURL = `${process.env.AP_SERVER_IP}:${process.env.AP_SERVER_PORT}`;
const axios = require('axios');
const session = require('./helpers/verifySession');
const { publishClients, actionType } = require('../routes/common/event-publisher');


const RestPassword = async (req, res, next) => {
    try {

        const {password, conformPassword, username} = req.body;

        if (password != conformPassword) {
            throw new httpErrors.NotFound(`Password do not match`)
        }

        const user = await models.LocalUsers.findOne({
            where: {
                userName: username
            }
        })

        if (!user) {
            throw new httpErrors.NotFound(`No client found`)
        }


        user.set("change_pass", false)
        await models.Client.update({
            is_active: true
            }, {
            where: {
                client_type: 'Server',
                user_id: user.id,
                device_id: null
            }
        });


        const pwdHash = crypto
            .createHash('sha256')
            .update(password)
            .digest('hex');

        user.set("password", pwdHash)

        await user.save();

        return res.status(200).send({
            'success': true
        })

    } catch (e) {
        return res.status(401).send({
            'success': false
        })
    }
}
const requestRestPassword = async (req, res, next) => {
    try {
        const { email } = req.body;
        let admin_portal_url = `https://${adminPortalURL}/api/localUsers/sendResetLink`;
        let payload = {email};
        console.log('------------api-------------', admin_portal_url);
        let response = await axios.post(admin_portal_url, payload);
        console.log('Email response', response);
        return res.status(200).send({
            'success': true,
             message : 'email sent',
        });

    } catch (error) {
        console.log(error);
        return res.status(404).send({
            'success': false,
             message : 'email address not found',
        })
    }
}


//GET /verify/otp
const verifyOtp = async (req, res, next) => {
    try {

        const {
            username,
            token
        } = req.query;

        //TODO : Need to move to validations
        if (!username) throw new httpErrors.UnprocessableEntity('username is required');

        if (!token) throw new httpErrors.UnprocessableEntity('token is required');

        const client = await models.Client.findOne({
            attributes: ['id', 'user', 'name', 'linOTP_token'],
            where: {
                user: username,
                linOTP_token: {
                    [Op.ne]: null
                }
            }
        });

        res.json({
            success: !client ? false : client.verifyOtp(token)
        });
    } catch (error) {
        next(error);
    }
}

const getBridgeClientDetail = async (req, res, next) => {
    try {
        if (res.locals && res.locals.setWrongAttempts) {
            const {
                error
            } = res.locals.setWrongAttempts
            const errorStatus = error && error.name === 'ADCustomError' ? 505 : 401;
            return res.status(errorStatus).json({...error})
        }
        const {username, bridgeName} = req.body;

        const user = await models.LocalUsers.findOne({
            where: {
                userName: username
            }
        })

        const client = await models.Client.findOne({
            where: {
                Name: {
                    [Op.eq]: `{${user.name}}@{${bridgeName}}`
                }
            }
        })
        if (!client) {
            throw new httpErrors.NotFound(`No client found`);
            return;
        }

        if (user.change_pass == 1) {
            return res.status(200).json({'change_password': true});
        }

        const check_mfa_global = await models.Settings.findOne({
            attributes: ['admin_mfa'],
            where:{},
            raw:true
        });

        if(check_mfa_global.admin_mfa == 1 && user.client_mfa == 1){
            return res.status(200).send({
                agent_id: client.agent_id,
                serial_number: client.serial_number,
                device_hardware_id: client.device_hardware_id,
                client_mfa: true
            })
        }else{
            return res.status(200).send({
                agent_id: client.agent_id,
                serial_number: client.serial_number,
                device_hardware_id: client.device_hardware_id,
                client_mfa: false
            })
        }

    } catch (e) {
        next(e);
    }
}

const getBridgeSlaveClientDetail = async (req, res, next) => {
    try {
        const {username, bridgeName} = req.body;

        const user = await models.LocalUsers.findOne({
            where: {
                userName: username
            }
        })

        const client = await models.Client.findOne({
            where: {
                Name: {
                    [Op.eq]: `{${user.name}}@{${bridgeName}}`
                }
            }
        })
        if (!client) {
            throw new httpErrors.NotFound(`No client found`);
            return;
        }

        if (user.change_pass == 1) {
            return res.status(200).json({'change_password': true});
        }
        else
            return res.status(200).json({'change_password': false});
    } catch (e) {
        next(e);
    }
}

const updateClientRiskScore = async (req, res, next) => {
    try {
        const { agent_id, risk_score } = req.body;

        const client = await models.Client.findByPk(agent_id);

        if(!client){
            throw new httpErrors.NotFound('No client found.');
        }

        await client.update({ risk_score });


        // Adding alert log for risk score update
        let type = 'Device Health';
        let message = `Risk Score ${risk_score} reported by external entity for ${client.Name} (${client.id})`;

        // Add alert log for risk score update
        await models.sequelize.query(
            "INSERT INTO AlertLogs (type, message) VALUES (?, ?)",
            {
              replacements: [type, message],
              type: models.sequelize.QueryTypes.INSERT,
            }
        )

        await publishClients(actionType.UPDATED, {
            ids: [ client.id ],
            mode: 0,
            data: { risk_score: +risk_score },
            type: client.client_type
        });

        return res.json({
            success: true,
            message: 'Edited Successfully'
        });

    } catch (error) {
        next(error);
    }
}

const updateClientEvent = async (req, res, next) => {
    try {
        let { agent_id, event } = req.body;

        const client = await models.Client.findByPk(agent_id);

        if(!client){
            throw new httpErrors.NotFound('No client found.');
        }

        await client.update({ event });

        if (event == 'false' || event == '0' || event == 0 || event == false) {
            event = 0;
        } else {
            event = 1;
        }

        await publishClients(actionType.UPDATED, {
            ids: [ client.id ],
            mode: 0,
            data: { event: event },
            type: client.client_type
        });

        return res.json({
            success: true,
            message: 'Edited Successfully'
        });

    } catch (error) {
        next(error);
    }
}

module.exports = {
    verifyOtp,
    getBridgeClientDetail,
    getBridgeSlaveClientDetail,
    requestRestPassword,
    verifyOtp,
    RestPassword,
    updateClientRiskScore,
    updateClientEvent
}
