const models = require('../models');
const httpErrors = require('http-errors');
const { publishClients, actionType } = require('../routes/common/event-publisher');

const updateUserEvent = async (req, res, next) => {
    try {
        const { event, user } = req.body;
        if (typeof event === 'undefned' || !user) {
            return res.status(400).send({
                success: false,
                message: 'Both event and user are required parameters.',
            });
        }

        if (typeof event !== 'boolean') {
            return res.status(400).send({
                success: false,
                message: 'Event must be a boolean value.',
            });
        }

        const userData = await models.LocalUsers.findOne({
            where: {
                [models.Sequelize.Op.or]: [
                    { userName: user },
                    { email: user },
                ],
            },
        });

        if (!userData) {
            throw new httpErrors.NotFound(`User not found`);
        }

        const clients = await models.Client.findAll({
            where: {
                user_id: userData.id,
            },
        });

        if (!clients || clients.length === 0) {
            throw new httpErrors.NotFound(`No clients found for the user`);
        }

        await models.Client.update(
            { event: event },
            {
                where: {
                    user_id: userData.id,
                },
            }
        );

        const clientIds = clients.map(client => client?.id);

        await publishClients(actionType.UPDATED, {
            ids: clientIds,
            mode: 0,
            data: { event: event },
        });

        res.status(200).send({
            success: true,
            message: `Event updated successfully for all clients of user ${user}.`,
        });
    } catch (error) {
        if (error instanceof httpErrors.NotFound) {
            return res.status(404).send({
                success: false,
                message: error.message,
            });
        } else {
            return res.status(500).send({
                success: false,
                message: `An error occurred`,
            });
        }
    }
};

const updateDeviceEvent = async (req, res, next) => {
    const { event, device_id } = req.body;

    try {
        if (typeof event === 'undefned' || !device_id) {
            return res.status(400).send({
                success: false,
                message: 'Both event and device_id are required parameters.',
            });
        }

        if (typeof event !== 'boolean') {
            return res.status(400).send({
                success: false,
                message: 'Event must be a boolean value.',
            });
        }

        const device = await models.DeviceInventories.findOne({
            where: {
                device_id: device_id,
            },
        });

        if (!device) {
            throw new httpErrors.NotFound(`Device not found`);
        }

        const client = await models.Client.findOne({
            where: {
                device_id: device.id,
            },
        });

        if (!client) {
            throw new httpErrors.NotFound(`Client not found for the device`);
        }

        await models.Client.update(
            { event: event },
            {
                where: {
                    device_id: device.id,
                },
            }
        );

        await publishClients(actionType.UPDATED, {
            ids: [ client?.id ],
            mode: 0,
            data: { event: event },
            type: client?.client_type
        });

        res.status(200).send({
            success: true,
            message: `Event updated successfully for client ${client.Name}.`,
        });
    } catch (error) {
        if (error instanceof httpErrors.NotFound) {
            return res.status(404).send({
                success: false,
                message: error.message,
            });
        } else {
            return res.status(500).send({
                success: false,
                message: `An error occurred`,
            });
        }
    }
};

module.exports = {
    updateUserEvent,
    updateDeviceEvent
}