const crypto = require('crypto');
const models = require('../models');
const argon2 = require('argon2');
const cookie = require('cookie');
const jwt = require('jsonwebtoken');

const secretSession = async(req, res, next) => {
    try{
        const {email, password} = req.body;
        let verifyUser = false;
        
        const publicUser = await models.User.findOne({
            where: {
                email: email
            }
        })

        const isPasswordMatch =  await argon2.verify(publicUser.dataValues.password, password);
        
        if(!publicUser)
            return res.status(404).send({
                success: false,
                message: 'No user found'
            });

        if (!isPasswordMatch)
            return res.status(403).send({
                success: false,
                message: 'Invalid User'
            });

        const userRole = await models.UserRole.findOne({
            where: {
                userId: publicUser.dataValues.id
            }
        })

        if(!userRole)
            return res.status(404).send({
                success: false,
                message: 'User Roles not found'
            });

        let query = `
            SELECT DISTINCT t.id as temp_id, t.name, t.description
            FROM Templates t
            INNER JOIN TemplatePermissions tp ON tp.temp_id = t.id
            INNER JOIN Permissions p ON p.id = tp.permission_id
            INNER JOIN Privilege pv ON pv.id = p.privilege_id
            INNER JOIN UserTemplates ut ON ut.temp_permission_id = tp.id
            INNER JOIN Users u ON u.id = ut.user_id
            WHERE u.id = ${publicUser.id} AND temp_id = 6
        `;
    
        let onlyPublic = (await models.sequelize.query(query))[0];

        if(!onlyPublic[0]){
            return res.status(500).send({
                success: false,
                message: 'Invalid User'
            });
        }

        const payload = { id: publicUser.dataValues.id, email: email, role: onlyPublic[0].name };
        const sessionKey = jwt.sign(payload, process.env.JWT_SECRET_KEY, { expiresIn: '10m' });

        const expirationTime = 10;
        const currentTime = Math.floor(Date.now() / 1000);
        const expirationTimestamp = currentTime + expirationTime * 60; 
  
        res.setHeader('Set-Cookie', cookie.serialize('sessionKey', sessionKey, {
            httpOnly: true,
            secure: true,
            maxAge: expirationTimestamp - currentTime,
            path: '/api' 
        }));

        return res.json({ 
            sessionKey,
            expiration: expirationTimestamp,
            success: true 
        });

    }catch(error) {
        next(error)
    }
}

module.exports = {
    secretSession
}