const {Op} = require('sequelize');
const models = require('../models');
const httpErrors = require('http-errors');

const validate = async (req, res, next) => {

    const transaction = await models.sequelize.transaction();
    const { userInfo } = req.userData;
    
    try{

        if(Object.keys(req.body).length === 0){
            return res.status(403).send({
                success: false,
                message: `Invalid parameters`
            });
        }

        const { hostname } = req.body;

        const host = await models.DeviceInventories.findOne({
            where: {
                host_name: hostname
            }
        });

        if(!host || req.body.hostname === ""){
            throw new httpErrors.NotFound(`No host found`);
        }

        var deviceName = host.userName;

        if(!host){
            throw new httpErrors.NotFound(`No host found`);
        }


        await models.DeviceInventories.update(
            { inventory_sync_state: 'Failed' },
            { where: { host_name: hostname }, transaction }
        );

        const logMessage = {
            action: `Inventory sync state of device ${deviceName} updated`,
        };


        await models.AdminAccessLogs.create(
            {
                userId: userInfo,
                action: logMessage.action,
                priority: 'Medium',
                requestBody: JSON.stringify(req.body),
                requestParams: JSON.stringify(req.params),
                requestQueryParams: JSON.stringify(req.query),
                createdAt: new Date(),
                updatedAt: new Date()
            },
            { transaction }
        );


        await transaction.commit();

          res.status(200).send({
            success: true,
            message: `Inventory sync state updated successfully`
        });



    }catch(e){
        await transaction.rollback();

        if (e instanceof httpErrors.NotFound) {
            return res.status(404).send({
                success: false,
                message: e.message
            });
        }else{
            return res.status(500).send({
                success: false,
                message: `An error occured`
            });
        }

    }
}


module.exports = {
    validate,
}