const models = require('../models');
const httpErrors = require('http-errors');
const crypto = require('crypto');
const moment = require('moment');

module.exports = async (req, res, next) => {
    try{
        
        let request_data = Object.assign({},req.body);
        delete request_data.signature;
        delete request_data.api_key;

        const { api_key,signature,timestamp } = req.body;

        if(!timestamp) throw new httpErrors.BadRequest('Bad request.Timestamp is missing.');

        const time = moment.unix(timestamp);

        if(!time.isValid()){
            throw new httpErrors.BadRequest('Invalid timestamp');
        }

        const diffInMinutes = moment().diff(time, 'second');

        if(diffInMinutes > 30 || diffInMinutes < -30){
            throw new httpErrors.BadRequest('Invalid timestamp. Time must be between one minute');
        }
    
        const user = await models.User.findOne({
            where:{ 
                public_key:api_key
            },
            attributes:['secret_key']
        });

        request_data = Object.keys(request_data).sort().reduce(
            (obj, key) => { 
              obj[key] = request_data[key]; 
              return obj;
            }, 
            {}
        );
        if(!user){
            throw new httpErrors.NotFound('Invalid api key');
        }

        const signatureToVerify = crypto.createHmac('sha256',user.secret_key).update(JSON.stringify(request_data)).digest('hex');

        if(
            signatureToVerify.length !== signature.length || 
            !crypto.timingSafeEqual(Buffer.from(signatureToVerify),Buffer.from(signature))
        ){
            throw new httpErrors.Unauthorized('Signature does not match');
        }

        next();

    }catch(error){
        next(error);
    }
}
