const models = require('../models');
const argon2 = require('argon2');

module.exports = async (req, res, next) => {
  const { verificationPassword } = req.body;
  const { id } = req.user;
  if (verificationPassword) {
    try {
      const user = await models.User.findOne({
        attributes: ['password'],
        where: {
          id
        }
      });
      if (user) {
        const match = await argon2.verify(user.password, verificationPassword);
        if (match) {
          next();
        } else {
          throw new Error('Passwords do not match');
        }
      } else {
        throw new Error('User not found');
      }
    } catch (err) {
      res.status(403).send({
        success: false
      });
    }
  } else {
    res.status(403).send({
      success: false
    });
  }
};
