const models = require('../models');
const cookie = require('cookie');
const jwt = require('jsonwebtoken');

module.exports = async (req, res, next) => {

    const cookies = cookie.parse(req.headers.cookie || '');
    const sessionData = {
        id: '',
        email: '',
        role: ''
    };

    try{
        jwt.verify(cookies.sessionKey, process.env.JWT_SECRET_KEY, (error, decoded) => {
            if (error) {
                throw new Error('Session key invalid');
            } else {
                sessionData.id = decoded.id;
                sessionData.email = decoded.email;
                sessionData.role = decoded.role;
                sessionData.issueAt = decoded.iat;
                sessionData.expiration = decoded.exp;
                const currentTime = Math.floor(Date.now() / 1000);
                if (!(currentTime >= decoded.iat && currentTime <= decoded.exp)) {
                    res.status(403).send({
                        'error': 'JWT expired',
                        'success': false
                    })
                }
             }
        });
       
        req.userData = {
            'userInfo': sessionData.id
        }
    
        const publicUser = await models.User.findOne({
            where: {
                email: sessionData.email
            }
        })
        
        if(!publicUser)
            return res.status(404).send({
                success: false,
                message: 'No user found'
            });
    
        next();

    }catch(error) {
        res.status(403).send({
            'error': 'JWT expired',
            'success': false
        })
    }
};
