const models = require('../models');
const crypto = require('crypto');
const LdapManager = require('../routes/common/ldap-manager');

class LDAPAuthenticationFailedError extends Error {
  constructor(status, allowedStatuses) {
    super('LDAP could not authenticated provided credentials');
    this.name = 'LDAPAuthenticationFailedError';
  }
}

class LOCALAuthenticationFailedError extends Error {
  constructor(status, allowedStatuses) {
    super('Local Users could not authenticated provided credentials');
    this.name = 'LOCALAuthenticationFailedError';
  }
}

const withLdapAuth = async (req, res, next) => {
  console.log('withLdapAuth is working')
    const { username, password } = req.body;
    const pwdHash = crypto
            .createHash('sha256')
            .update(password)
            .digest('hex');
    let localUser = await models.LocalUsers.findOne({
      where: {
        userName: username,
        // password: pwdHash
      }
    });
    if(localUser && localUser.identity_provider == 'Local User') {
      localUser = await models.LocalUsers.findOne({
        where: {
          userName: username,
          password: pwdHash
        }
      });
      if(!localUser) {
        res.locals.setWrongAttempts = {
          error:new LOCALAuthenticationFailedError()
        };
        return next();
      }
      return next();
    }
  const ldapManager = new LdapManager();
  let isLdapReachable = true;
  var ldapAuth = false;
  await models.Ldap.findAll()
  .then(adConfigs => {
    
    // Use `map` to create an array of promises
    const ldapAuthPromises = adConfigs.map(ldap => {
      console.log('This is the ldap: ', ldap.LDAP_user);

      if (ldap) {
        return ldapManager.createLdapConnection(ldap)
          .then(() => {
            let userDN;
            if (ldap.LDAP_user.startsWith('uid=')) {
              const remainingDN = ldap.LDAP_user.split(',').slice(1).join(',');
              userDN = `uid=${username},${remainingDN}`;
            } else if (ldap.LDAP_user.includes('CN=')) {
              let userText = ldap.LDAP_user.toLowerCase();
              userText = userText.substring(userText.indexOf('dc='))
                .replace(/dc=/g, '')
                .replace(/,/g, '.');
              userDN = `${username}@${userText}`;
            } else {
              let domainPart;
              if (ldap.LDAP_user.includes('@')) {
                domainPart = ldap.LDAP_user.split('@')[1];
                userDN = `${username}@${domainPart}`;
              } else {
                const dcParts = ldap.LDAP_dc.match(/DC=([\w-]+)/g);
                if (dcParts && dcParts.length > 0) {
                  domainPart = dcParts.map(dc => dc.split('=')[1]).join('.');
                  userDN = `${username}@${domainPart}`;
                }
              }
            }

            console.log('This is the userDN:', userDN);
            return ldapManager.bindUser(userDN, password);
          })
          .catch(error => {
            if (error.name === 'ADCustomError') {
              return Promise.reject(error);
            }
            if (error.name == 'ConnectionError') {
              isLdapReachable = false;
            }
            return Promise.resolve(false);
          });
      } else {
        return Promise.resolve(false);
      }
    });

    // Wait for all LDAP authentication attempts to complete
    return Promise.all(ldapAuthPromises);
  })
  .then(results => {
    // `results` is an array of authentication outcomes, we check if at least one is true
    const isLdapAuthenticated = results.includes(true);
    
    ldapAuth = isLdapAuthenticated;

    if (!isLdapAuthenticated) {
      // Check in local users
      const hash = crypto.createHash('sha256').update(password).digest('hex');
      return models.LocalUsers.findOne({
        where: { userName: username, password: hash }
      });
    } else {
      return Promise.resolve(null);
    }
  })
  .then(localUser => {
    if (isLdapReachable == false && !localUser) {
      const customError = new Error('ldap is not reachable');
      customError.name = 'ADNotReachable';
      throw customError;
    } else if (ldapAuth) {
      return ldapManager.bindDefaultUser();
    } else {
      return localUser
        ? Promise.resolve()
        : Promise.reject(new LOCALAuthenticationFailedError());
    }
  })
  .then(() => {
    next();
  })
  .catch(err => {
    if (err.name === 'ADCustomError') {
      res.locals.setWrongAttempts = { error: err };
      return next();
    } else if (err.name === 'ADNotReachable') {
      res.status(503).json({ name: 'ADNotReachable' });
    } else if (err instanceof LOCALAuthenticationFailedError) {
      res.locals.setWrongAttempts = { error: new LOCALAuthenticationFailedError() };
      next();
    } else {
      res.locals.setWrongAttempts = { error: new LDAPAuthenticationFailedError() };
      next();
    }
  });
}

  module.exports = {
      withLdapAuth
  }