'use strict';
module.exports = function(sequelize, DataTypes) {
  var ClientAccessRestriction = sequelize.define('ClientAccessRestriction', {
    clientId: DataTypes.INTEGER,
    serviceId: DataTypes.INTEGER,
    months: DataTypes.STRING,
    week_days: DataTypes.STRING,
    access_time_from_hour: DataTypes.STRING,
    access_time_from_minute: DataTypes.STRING,
    access_time_to_minute: DataTypes.STRING,
    access_time_to_hour: DataTypes.STRING
  });

  ClientAccessRestriction.associate = function(models) {
    ClientAccessRestriction.belongsTo(models.Client, {
      foreignKey: 'clientId',
      targetKey: 'id'
      // as:'client'
    });
  };
  return ClientAccessRestriction;
};
