'use strict';
module.exports = function(sequelize, DataTypes) {
  let Connection = sequelize.define(
    'Connection',
    {
      AGENT_ID: DataTypes.INTEGER,
      ipv4_address: DataTypes.STRING,
      CONNECTION_ATTEMPT_TIME: DataTypes.DATE,
      DISCONNECTION_TIME: DataTypes.DATE,
      is_login_successfull: DataTypes.BOOLEAN,
      is_logout_successfull: DataTypes.BOOLEAN,
      client_name: DataTypes.STRING,
      client_userName: DataTypes.STRING,
      client_device_os: DataTypes.STRING,
      client_geoip_track: DataTypes.BOOLEAN,
      location: DataTypes.STRING
    },
    {
      timestamps: false
    }
  );

  Connection.associate = function(models) {
    Connection.belongsTo(models.Client, { foreignKey: 'agent_id' });
  };

  return Connection;
};
