'use strict';

const FIRST_ROLE = 'Primary';
const SECOND_ROLE = 'Secondary';

const httpErrors = require('http-errors');

module.exports = function(sequelize, DataTypes) {
  var Controller = sequelize.define('Controller', {
    Name: DataTypes.STRING,
    email: DataTypes.STRING,
    controller_id: DataTypes.INTEGER,
    ipv4_address: DataTypes.STRING,
    protocol: DataTypes.STRING,
    port: DataTypes.INTEGER,
    public_ipv4_address: DataTypes.STRING,
    public_ipv4_port: DataTypes.INTEGER,
    spa_port: DataTypes.INTEGER,
    is_active: DataTypes.BOOLEAN,
    enc_key: DataTypes.STRING,
    HMacKey: DataTypes.STRING,
    device_os: DataTypes.STRING,
    device_hardware_id: DataTypes.STRING,
    cacert: DataTypes.BLOB('medium'),
    clientcrt: DataTypes.BLOB('medium'),
    clientpem: DataTypes.BLOB('medium'),
    link_key: DataTypes.STRING,
    link_key_expiry: DataTypes.DATE,
    heart_beat: DataTypes.BOOLEAN,
    heart_beat_sent_at: DataTypes.DATE,
    installer_status: DataTypes.STRING,
    onPrenDownloadLink: DataTypes.STRING,
    isDownloadPackage: DataTypes.BOOLEAN,
    packageDownloaded: DataTypes.BOOLEAN,
    pkg_url: DataTypes.STRING,
    roleId:DataTypes.INTEGER,
    connected_clients: {
      type: DataTypes.INTEGER
    }
  });


  //Hooks life cycle methods

  Controller.addHook('beforeCreate',async function(controller,_){

    const models = require('../models');

    const controllerCount = await Controller.count({ where: { }});
    
    let roleName = FIRST_ROLE;

    if(controllerCount >= 1) roleName = SECOND_ROLE;

    const roleId = await models.ComponentRole.findOne({
      attributes: ['id'],
      where:{ 
        role:roleName,
      }
    });

    controller.roleId = roleId.id;
    controller.role = roleName;

  });


  Controller.addHook('beforeUpdate',async function(controller,_){

    const models = require('../models');

    if(controller.Role && controller.Role.role === FIRST_ROLE){
      const secondaryCount = await models.ComponentRole.count({
        where:{
          role:SECOND_ROLE
        },
        include:[
          { 
            model:models.Controller,
            as:"Controllers",
            where:{ }
          }
        ]
      });

      console.log(secondaryCount);

      if(secondaryCount >= 1 ){
        throw new httpErrors.UnprocessableEntity('Can not delete primary controller if secondary controller exist.');
      }

    }

  })

  Controller.associate = function(models) {
    Controller.belongsToMany(models.Gateway, {
      through: 'ControllerGateway',
      foreignKey: 'controllerId'
    });
    Controller.hasOne(models.ControllerHealth);
    Controller.belongsTo(models.ComponentRole,{ foreignKey: 'roleId',as:'Role' });
  };
  return Controller;
};
