'use strict';
module.exports = (sequelize, DataTypes) => {
  const ControllerHealth = sequelize.define(
    'ControllerHealth',
    {
      OS: DataTypes.STRING,
      controllerId: DataTypes.INTEGER,
      CPU: DataTypes.STRING,
      memTotal: DataTypes.INTEGER,
      memFree: DataTypes.INTEGER,
      storageTotal: DataTypes.INTEGER,
      storageFree: DataTypes.INTEGER,
      cpuUtilization: DataTypes.FLOAT,
      mainProcessCPUUtilization: DataTypes.FLOAT,
      snifferProcessCPUUtilization: DataTypes.FLOAT,
      lastErrorLog: DataTypes.STRING,
      snifferLastErrorLog: DataTypes.STRING,
      componentVersion: DataTypes.STRING
    },
    {}
  );
  ControllerHealth.associate = function(models) {
    // associations can be defined here
    ControllerHealth.belongsTo(models.Controller, {
      foreignKey: 'controllerId'
    });
  };
  return ControllerHealth;
};
