'use strict';
module.exports = (sequelize, DataTypes) => {
  const Departments = sequelize.define(
    'Departments',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER
      },
      createdById: {
        type: DataTypes.INTEGER
      },
      updatedById: {
        type: DataTypes.INTEGER
      },
      name: {
        type: DataTypes.STRING
      },
      organization_id: {
        type: DataTypes.INTEGER
      },
      createdAt: {
        type: DataTypes.DATE
      },
      updatedAt: {
        type: DataTypes.DATE
      }
    },
    {}
  );
  Departments.associate = function (models) {
    // associations can be defined here
    Departments.hasOne(models.LocalUsers, { foreignKey: 'department' } );

    Departments.belongsTo(models.Organizations, { foreignKey: 'organization_id' });

    Departments.hasMany(models.DeviceInventories, { foreignKey: 'department' })

  };
  return Departments;
};
