'use strict';
module.exports = (sequelize, DataTypes) => {
  const DeviceInventories = sequelize.define(
    'DeviceInventories',
    {
      userName: {
        type: DataTypes.STRING,
        allowNull: false
      },
      deviceSerialNumber: {
        type:DataTypes.STRING,
        unique:true 
      },
      deviceTag: {
        type: DataTypes.STRING,
        unique: true
      },
      device_name: {
        type: DataTypes.STRING
      },
      device_type: {
        type: DataTypes.STRING
      },
      device_id: {
        type: DataTypes.INTEGER
      },
      department: {
        type: DataTypes.STRING
      },
      location: {
        type: DataTypes.STRING
      },
      ip_address: {
        type: DataTypes.STRING
      },
      mac_address: {
        type: DataTypes.STRING
      },
      host_name: {
        type: DataTypes.STRING
      },
      model: {
        type: DataTypes.STRING
      },
      manufacturer: {
        type: DataTypes.STRING
      },
      device_groups : {
        type: DataTypes.TEXT('long')
      },
      iot_device_type: {
        type: DataTypes.STRING
      },
      hypervisor_version: {
        type: DataTypes.STRING
      },
      has_agent: {
        type: DataTypes.BOOLEAN
      },
      user_id: {
        type: DataTypes.INTEGER
      },
      darkening_state: {
        type: DataTypes.BOOLEAN
      },
      geoip_track: {
        type: DataTypes.BOOLEAN
      },
      os: {
        type: DataTypes.STRING
      },
      os_version: {
        type: DataTypes.STRING
      },
      risk_score: {
        type: DataTypes.INTEGER
      },
      is_reference_machine: {
        type: DataTypes.BOOLEAN
      },
      inventory_sync_state: {
        type: DataTypes.STRING
      },
      last_sync_time: {
        type: DataTypes.DATE
      }
    },
    {}
  );
  DeviceInventories.associate = function(models) {

    DeviceInventories.hasOne(models.Client, { foreignKey: 'device_id' });
    DeviceInventories.belongsTo(models.Departments, { foreignKey: 'department' });
    // associations can be defined here
  };
  return DeviceInventories;
};
