const httpErrors = require('http-errors');
const _ = require('lodash');

('use strict');
module.exports = (sequelize, DataTypes) => {
  const GatewayGroups = sequelize.define(
    'GatewayGroups',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER
      },
      name: {
        type: DataTypes.STRING
      },
      description: DataTypes.TEXT,
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    },
    {}
  );
  GatewayGroups.associate = function(models) {
    
    GatewayGroups.hasMany(models.GatewayGroupPivot, {
      foreignKey: 'gateway_group_id',
      as: 'GatewayGroupsGateways',
      onDelete: 'CASCADE',
      hooks: true
    });

    GatewayGroups.belongsToMany(models.Gateway, {
      foreignKey: 'gateway_group_id',
      through: models.GatewayGroupPivot
    });
    
    GatewayGroups.belongsToMany(models.RoutingPolicies, {
      through: models.GatewayGroupRoutingPolicies,
      foreignKey: 'gateway_group_id'
    });

  };

  GatewayGroups.addHook('beforeCreate', checkIfGroupExist);
  GatewayGroups.addHook('beforeUpdate', checkIfGroupExist);

  /**
   * Check if the name of the policy already exist
   * @param {string} group
   */
  async function checkIfGroupExist(group, options) {
    group.dataValues.name = _.upperFirst(
      _.toLower(group.dataValues.name.trim())
    );
    if (!group.dataValues.name) {
      throw new httpErrors.UnprocessableEntity('Name is required');
    }

    const isNameExist = await GatewayGroups.findOne({
      where: {
        name: group.dataValues.name,
        id: {
          [Op.ne]: group.dataValues.id
        }
      }
    });

    if(isNameExist){
      throw new httpErrors.Conflict('Gateway Group already exist with same name.');
    }

    
    // const result = (await GatewayGroups.findOne({
    //   where: {
    //     ...!group.id ? {} : {
    //       id: {
    //         [Op.ne]: group.id
    //       }
    //     },
    //     [Op.or]: {
    //       all_gateways: true,
    //       all_services: true
    //     }
    //   }
    // }) || {});

    // if (
    //   (result.all_gateways || result.all_services) &&
    //   (group.all_gateways || group.all_services)
    // ) {
    //   throw new httpErrors.Conflict('Group with all services and all gateways already exist.');
    // }


    // if (
    //   group.all_gateways ||
    //   (options.context && options.context.gateways && options.context.gateways.length)
    // ) {
      
    //   if(result.all_gateways) {
    //     throw new httpErrors.Conflict(
    //       'Can\'t assign gateways because, group with all services and all gateways exist.'
    //     )
    //   }

    //   const count = await sequelize.models.Gateway.count({
    //     where: {
    //       ...group.all_gateways ? {} : {
    //         id: {
    //           [Op.in]: options.context.gateways
    //         }
    //       },
    //       [Op.and]: [
    //         {
    //           gateway_group_id: {
    //             [Op.ne]: null
    //           } 
    //         },
    //         ...!group.id ? [] : [{
    //           gateway_group_id: {
    //             [Op.ne]: group.id
    //           }
    //         }]
    //       ]
    //     }
    //   })

    //   if (group.all_gateways && count) {
    //     throw new httpErrors.Conflict('Group(s) exist with gateway(s) assigned');
    //   } else if (count) {
    //     throw new httpErrors.Conflict('Gateway(s) already exist in another group');
    //   }
    // }

    // if (
    //   group.all_services ||
    //   (options.context && options.context.services && options.context.services.length)
    // ) {

    //   if(result.all_services) {
    //     throw new httpErrors.Conflict(
    //       'Can\'t assign services because, group with all services and all gateways exist.'
    //     )
    //   }

    //   const count = await sequelize.models.Service.count({
    //     where: {
    //       ...group.all_services ? {} : {
    //         id: {
    //           [Op.in]: options.context.services
    //         }  
    //       },
    //       [Op.and]: [
    //         {
    //           gateway_group_id: {
    //             [Op.ne]: null
    //           } 
    //         },
    //         ...!group.id ? [] : [{
    //           gateway_group_id: {
    //             [Op.ne]: group.id
    //           }
    //         }]
    //       ]
    //     }
    //   })

    //   if (group.all_services && count) {
    //     throw new httpErrors.Conflict('Group(s) exist with service(s) assigned');
    //   } else if (count) {
    //     throw new httpErrors.Conflict('Service(s) already exist in another group')
    //   }
    // }
  }

  return GatewayGroups;
};
