'use strict';
const httpErrors = require('http-errors');
const crypto = require('crypto');
module.exports = function(sequelize, DataTypes) {
  var Gateway = sequelize.define('Gateway', {
    Name: DataTypes.STRING,
    agent_id: DataTypes.INTEGER,
    ipv4_address: DataTypes.STRING,
    protocol: DataTypes.STRING,
    port: DataTypes.INTEGER,
    public_ipv4_address: DataTypes.STRING,
    public_ipv4_port: DataTypes.INTEGER,
    spa_port: DataTypes.INTEGER,
    is_active: DataTypes.BOOLEAN,
    counter: DataTypes.STRING,
    enc_key: DataTypes.STRING,
    HMacKey: DataTypes.STRING,
    email: DataTypes.STRING,
    hardware_id: DataTypes.STRING,
    cacert: DataTypes.BLOB('medium'),
    clientcrt: DataTypes.BLOB('medium'),
    clientpem: DataTypes.BLOB('medium'),
    link_key: DataTypes.STRING,
    link_key_expiry: DataTypes.DATE,
    heart_beat: DataTypes.BOOLEAN,
    heart_beat_sent_at: DataTypes.DATE,
    deployment_location: DataTypes.INTEGER,
    installer_status: DataTypes.STRING,
    onPrenDownloadLink: DataTypes.STRING,
    isDownloadPackage: DataTypes.BOOLEAN,
    packageDownloaded: DataTypes.BOOLEAN,
    device_binding: DataTypes.BOOLEAN,
    connected_clients: DataTypes.INTEGER,
    is_unique: DataTypes.BOOLEAN,
    subnet_ip: DataTypes.STRING,
    pkg_url: DataTypes.STRING,
    // gateway_group_id: DataTypes.INTEGER,
    proxy_enabled: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false
    },
    buildOs: {
      type: DataTypes.ENUM('ubuntuserver18', 'windowsserver', 'ubuntuserver20armv8', 'centosserver'),
      allowNull: false,
      defaultValue: 'ubuntu'
    }
  }, {
    defaultScope: {
      where: { }
    },
  });
  Gateway.associate = function(models) {
    Gateway.hasOne(models.GatewayHealth, { foreignKey: 'gatewayId' });
    Gateway.belongsToMany(models.Controller, {
      through: 'ControllerGateway',
      foreignKey: 'gatewayId'
    });

    Gateway.belongsToMany(models.Service, {
      through: 'GatewayService',
      foreignKey: 'gatewayId'
    });

    Gateway.hasMany(models.GatewayGroupPivot, {
      foreignKey: 'gateway_id',
      as: 'GatewayGatewayGroups',
      onDelete: 'CASCADE',
      hooks: true
    });

    Gateway.belongsToMany(models.GatewayGroups, {
      through: models.GatewayGroupPivot,
      foreignKey: 'gateway_id'
    });

    Gateway.belongsToMany(models.RoutingPolicies, {
      through: models.GatewayRoutingPolicies,
      foreignKey: 'gateway_id'
    });

  };

  return Gateway;
};
