'use strict';
module.exports = (sequelize, DataTypes) => {
  const GatewayHealth = sequelize.define(
    'GatewayHealth',
    {
      OS: DataTypes.STRING,
      gatewayId: DataTypes.INTEGER,
      CPU: DataTypes.STRING,
      memTotal: DataTypes.INTEGER,
      memFree: DataTypes.INTEGER,
      storageTotal: DataTypes.INTEGER,
      storageFree: DataTypes.INTEGER,
      cpuUtilization: DataTypes.FLOAT,
      mainProcessCPUUtilization: DataTypes.FLOAT,
      snifferProcessCPUUtilization: DataTypes.FLOAT,
      lastErrorLog: DataTypes.STRING,
      snifferLastErrorLog: DataTypes.STRING,
      componentVersion: DataTypes.STRING
    },
    {}
  );
  GatewayHealth.associate = function(models) {
    // associations can be defined here
    GatewayHealth.belongsTo(models.Gateway, {
      foreignKey: 'gatewayId'
    });
  };
  return GatewayHealth;
};
