/**
 * @typedef {Object} DataTable
 * @property {number} draw
 * @property {number} recordsTotal
 * @property {number} recordsFiltered
 * @property {Object[]} data
 * @property {Object} error
 * @return {Function}
 */
module.exports = (Model) => /** @return {Promise<DataTable>} */async (options = {}) => {
  
  options.limit = +options.limit || 10;
  options.offset = +options.offset || 0;
  options.offset = options.offset * options.limit;

  if(options.limit ==-1){
    delete options.limit;
    delete options.offset;
  }

  const draw = options.draw || 1;
  const mapper = options.mapper;

  delete options.mapper
  delete options.draw;

  try {
    
    let {count: totalRecords, rows: result} = await Model.findAndCountAll(options);
    

    if(options.group) totalRecords = totalRecords.length;

    if(mapper && typeof mapper === 'object') {
      result = result.map(res => 
        Object.keys(mapper).reduce((acc, key) => {
          if(res.hasOwnProperty(key)) {
            if(typeof mapper[key] === 'object') {
              const fn = mapper[key].fn;
              if (typeof res[key] === 'string' && !res[key]) {
                acc[mapper[key].mapTo] = 'Unknown';
              } else if (isNaN(res[key])) {
                acc[mapper[key].mapTo] = res[key] || 'Unknown';
              } else {
                acc[mapper[key].mapTo] = +res[key] || 0;
              }
              if(fn && typeof fn === 'function') 
                acc[mapper[key].mapTo] = fn(acc[mapper[key].mapTo]);
            } else {
              if (typeof res[key] === 'string' && !res[key]) {
                acc[mapper[key].mapTo] = 'Unknown';
              } else if (isNaN(res[key])) {
                acc[mapper[key]] = res[key] || 'Unknown';
              } else {
                acc[mapper[key]] = +res[key] || 0;
              }
            }
          }
          return acc;
        }, {})
      );
    }

    return {
      // draw,
      // recordsFiltered: totalRecords,
      recordsTotal: totalRecords,
      data: result
    }
  } catch (error) {
    return {
      // draw,
      recordsTotal: null,
      // recordsFiltered: null,
      error: {
        message: error.message
      }
    }
  }

};