'use strict';
module.exports = function(sequelize, DataTypes) {
  var Group = sequelize.define('Group', {
    name: DataTypes.STRING,
    description: DataTypes.TEXT,
    is_ldap_deleted: DataTypes.BOOLEAN
  });
  Group.associate = function(models) {
    Group.belongsToMany(models.Client, {
      through: 'GroupClient',
      foreignKey: 'groupId'
    });

    Group.belongsToMany(models.Service, {
      through: 'GroupService',
      foreignKey: 'groupId'
    });

    Group.belongsToMany(models.Entitlements, {
      through: models.ClientGroupPolicies,
      foreignKey: 'client_group_id'
    });

    Group.belongsToMany(models.DevicePolicies, {
      through: models.ClientGroupDevicePolicies,
      foreignKey: 'client_group_id'
    });

    Group.belongsToMany(models.SoftwarePolicies, {
      through: models.ClientGroupSoftwarePolicies,
      foreignKey: 'client_group_id'
    });

    Group.hasMany(models.GroupClient, { foreignKey: 'groupId' });
    Group.hasMany(models.GroupService, { foreignKey: 'groupId' });
    Group.hasOne(models.GroupDetail, { foreignKey: 'groupId' });
  };
  return Group;
};
