'use strict';
module.exports = function(sequelize, DataTypes) {
  var GroupClient = sequelize.define('GroupClient', {
    clientId: {
      type: DataTypes.INTEGER,
      primaryKey: true
    },
    groupId: {
      primaryKey: true,
      type: DataTypes.INTEGER
    }
  });
  GroupClient.removeAttribute('id');
  GroupClient.associate = function(models) {

    GroupClient.belongsTo(models.Client, { foreignKey: 'clientId' });
  };
  return GroupClient;
};
