'use strict';
module.exports = (sequelize, DataTypes) => {
    const LocalUsers = sequelize.define(
        'LocalUsers',
        {
            name: DataTypes.STRING,
            userName: DataTypes.STRING,
            email: DataTypes.STRING,
            password: DataTypes.STRING,
            link_expiry: DataTypes.DATE,
            is_used: DataTypes.BOOLEAN,
            link_key: DataTypes.STRING,
            change_pass: DataTypes.BOOLEAN,
            password_updated_at: DataTypes.DATE,
            temporary_password_expiry: DataTypes.DATE,
            // password_token: DataTypes.TEXT,
            identity_provider: {
                type: DataTypes.STRING,
                allowNull: false,
                defaultValue: 'Local User'
            },
            department: {
                type: DataTypes.INTEGER
            },
            linOTP_token: DataTypes.JSON,
            OTP_image_data: DataTypes.TEXT('long'),
            biometric_state: DataTypes.BOOLEAN,
            is_strong_mfa: {
                type: DataTypes.BOOLEAN,
                defaultValue: 0
            },
            mfa_status: DataTypes.STRING,
            risk_score: {
                type: DataTypes.INTEGER,
                allowNull: false,
                defaultValue: 1
            },
            client_mfa: DataTypes.BOOLEAN,
            contact: DataTypes.STRING
        },
        {}
    );
    LocalUsers.associate = function (models) {
        // associations can be defined here
        LocalUsers.belongsTo(models.Departments, {foreignKey: 'department'});
        LocalUsers.hasOne(models.Client, {foreignKey: 'user_id'});

    };
    return LocalUsers;
};
