'use strict';
module.exports = (sequelize, DataTypes) => {
  const Organizations = sequelize.define(
    'Organizations',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER
      },
      createdById: {
        type: DataTypes.INTEGER
      },
      updatedById: {
        type: DataTypes.INTEGER
      },
      name: {
        type: DataTypes.STRING
      },
      department_count: {
        type: DataTypes.INTEGER
      },
      createdAt: {
        type: DataTypes.DATE
      },
      updatedAt: {
        type: DataTypes.DATE
      }
    },
    {}
  );
  Organizations.associate = function (models) {
    // associations can be defined here
    Organizations.hasOne(models.Departments, { foreignKey: 'organization_id' })

  };
  return Organizations;
};
