'use strict';
module.exports = function(sequelize, DataTypes) {
  var Role = sequelize.define(
    'Role',
    {
      title: DataTypes.STRING,
      description: DataTypes.TEXT
    },
    {
      classMethods: {
        associate: function(models) {
          // associations can be defined here
          Role.belongsToMany(models.User, {
            through: 'UserRole',
            foreignKey: 'roleId'
          });
          Role.belongsToMany(models.Permission, {
            through: 'RolePermission',
            foreignKey: 'roleId'
          });
        }
      }
    }
  );
  return Role;
};
