'use strict';

const { Sequelize } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
  const SaasBridge = sequelize.define('SaasBridge', {
        name: {
            type: DataTypes.STRING,
            allowNull: false
        },
        clientId: {
            type: DataTypes.INTEGER,
            references:{
                model:'Clients',
                key:'id'
            },
            onDelete:'CASCADE'
        },
        serviceId: {
            type: DataTypes.INTEGER,
            references:{
                model:'Services',
                key:'id'
            },
            onDelete:'CASCADE'
        },
        mappedDomain: {
            type: DataTypes.STRING
        },
        authAgentDomain: {
            type: DataTypes.STRING,
        },
        authService: {
            type: DataTypes.ENUM('aws cognito', 'okta'),
            allowNull: false,
            defaultValue: 'aws cognito'
        },
        authServiceClientId: {
            type: DataTypes.STRING,
        },
        authServiceClientSecret: {
            type: DataTypes.STRING,
        },
        authServiceUrl: {
            type: DataTypes.STRING,
        },
        authServiceTokenUrl: {
            type: DataTypes.STRING,
        },
        authServiceUserInfoUrl: {
            type: DataTypes.STRING,
        },
        isEnable: DataTypes.BOOLEAN,
        email_token: DataTypes.STRING,
        email_token_used: DataTypes.BOOLEAN,
        email_token_expiry: DataTypes.DATE,
        createdAt: {
            allowNull: false,
            type: DataTypes.DATE,
            defaultValue:Sequelize.fn('NOW')
        },
        updatedAt: {
            allowNull: false,
            type: DataTypes.DATE,
            defaultValue:Sequelize.fn('NOW')
        }
    },
    {}
  );
  SaasBridge.associate = function(models) {
    SaasBridge.belongsTo(models.Client);
    SaasBridge.belongsTo(models.Service);
  };
  return SaasBridge;
};
