'use strict';
module.exports = (sequelize, DataTypes) => {
  const ServiceAccessLogs = sequelize.define(
    'ServiceAccessLogs',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER
      },
      agent_id: {
        type: DataTypes.INTEGER
      },
      client_physical_ip: {
        type: DataTypes.INTEGER.UNSIGNED
      },
      client_pseudo_ip: {
        type: DataTypes.INTEGER.UNSIGNED
      },
      service_id: {
        type: DataTypes.INTEGER
      },
      service_physical_ip: {
        type: DataTypes.INTEGER.UNSIGNED,
        get() {
          const rawValue = this.getDataValue('service_physical_ip');
          return rawValue ? rawValue : null;
        }
      },
      service_pseudo_ip: {
        type: DataTypes.INTEGER.UNSIGNED
      },
      client_tx_bytes: {
        type: DataTypes.INTEGER
      },
      service_tx_bytes: {
        type: DataTypes.INTEGER
      },
      log_start_time: {
        type: DataTypes.INTEGER.UNSIGNED
      },
      log_end_time: {
        type: DataTypes.INTEGER.UNSIGNED
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    },
    {}
  );
  ServiceAccessLogs.associate = function (models) {
    // associations can be defined here
    ServiceAccessLogs.belongsTo(models.Client, { foreignKey: 'agent_id' });
    ServiceAccessLogs.belongsTo(models.Service, { foreignKey: 'service_id' });
  };
  return ServiceAccessLogs;
};
