'use strict';
const httpErros = require('http-errors');
const { BOOLEAN, Op } = require('sequelize');

module.exports = function(sequelize, DataTypes) {
  var Service = sequelize.define('Service', {
    Name: DataTypes.STRING,
    port: DataTypes.INTEGER,
    protocol: DataTypes.STRING,
    service_id: DataTypes.INTEGER,
    is_active: DataTypes.BOOLEAN,
    ipv4_address: DataTypes.STRING,
    type: DataTypes.STRING,
    dummy_port: DataTypes.INTEGER,
    isGateWayAssigned: DataTypes.BOOLEAN,
    isClientAssigned: DataTypes.BOOLEAN,
    mappedurl: DataTypes.STRING,
    is_persistent: BOOLEAN,
    // gateway_group_id: DataTypes.INTEGER,
    proxy_enabled: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false
    },
  }, {
    defaultScope: {
      where: { }
    },
  });

  Service.addScope('GroupServices', (groupId, term) => {
    const models = require('../models');
    const whereClause = {};
    if (term !== '__SERVICES__') {
      whereClause['Name'] = {
        $like: `%${term}%`
      };
    }
    return {
      attributes: ['Name', 'id'],
      order: [[models.GroupService, 'serviceId', 'DESC']],
      include: [
        {
          attributes: ['serviceId'],
          model: models.GroupService,
          where: {
            groupId
          },
          required: term === '__SERVICES__' ? true : false
        }
      ],
      where: whereClause
    };
  });

  Service.associate = function(models) {
    Service.belongsToMany(models.Client, {
      through: 'ClientService',
      foreignKey: 'serviceId'
    });

    Service.belongsToMany(models.Entitlements, {
      through: models.ServicePolicies,
      foreignKey: 'service_id'
    });

    Service.belongsToMany(models.DevicePolicies, {
      through: models.ServiceDevicePolicies,
      foreignKey: 'service_id'
    });

    Service.belongsToMany(models.RoutingPolicies, {
      through: models.ServiceRoutingPolicies,
      foreignKey: 'service_id'
    });

    Service.hasMany(models.GatewayService, { foreignKey: 'serviceId' });
    Service.hasMany(models.ServiceAccessLogs, { foreignKey: 'service_id' });
    Service.hasMany(models.SaasBridge, { foreignKey: 'serviceId' });
    // Service.hasOne(models.GatewayGroups, { foreignKey: 'id' });

    Service.belongsToMany(models.Group, {
      through: 'GroupService',
      foreignKey: 'serviceId'
    });

    Service.hasMany(models.GroupService, { foreignKey: 'serviceId' });

    Service.belongsToMany(models.Gateway, {
      through: models.GatewayService,
      foreignKey: 'serviceId'
    });

    Service.belongsToMany(models.SoftwarePolicies, { 
      through: models.ServiceSoftwarePolicies,
      foreignKey: 'service_id' 
    });
  };


  Service.addHook('afterUpdate', updateGroupField);
  Service.addHook('afterCreate', updateGroupField);
  Service.addHook('beforeUpdate', checkGroupField);
  Service.addHook('beforeCreate',async (service,options) => {
    
    const models = require('../models');

    const [license,serviceCount] = await Promise.all([
      models.License.findOne({
        order: [['id', 'DESC']],
        limit: 1,
        attributes:['max_number_of_services']
      }),
      models.Service.count({
        where: { }
      })
    ]);

    console.log(license.max_number_of_services , serviceCount);

    if(license.max_number_of_services <= serviceCount){
      throw new httpErros.BadRequest('Can not add services because services limit reached.')
    }

    await checkGroupField(service, options);

  });


  async function checkGroupField(service, options) {
    // const count = await sequelize.models.GatewayGroups.count({
    //   where: {
    //     all_services: true
    //   }
    // });

    // if (count) {
    //   service.gateway_group_id = null;
    // }
  }

  async function updateGroupField(service, options) {
    // const _options = {
    //   where: {
    //     ...!service.gateway_group_id ? {
    //       all_services: true
    //     } : {
    //       id: service.gateway_group_id
    //     }
    //   },
    //   transaction: options.transaction || null
    // };

    // const [, gatwayGroups ] = await Promise.all([
    //   sequelize.models.GatewayGroups.update({
    //     services_updatedAt: new Date(),
    //   }, _options),
    //   sequelize.models.GatewayGroups.findAll({..._options, attributes: ['id']})
    // ]);
    
    // const gatways = await sequelize.models.Gateway.findAll({
    //   attributes: [
    //     'id',
    //     'gateway_group_id'
    //   ]
    // });

    // const gatwaysToPublish = {};

    // gatways.forEach(_g => {
    //   if(gatwaysToPublish.hasOwnProperty(_g.gateway_group_id)){
    //     gatwaysToPublish[_g.gateway_group_id].push(_g.id);
    //   }else{
    //     gatwaysToPublish[_g.gateway_group_id] = [];
    //     gatwaysToPublish[_g.gateway_group_id].push(_g.id);
    //   }
    // });

    // const keys = [...new Set(Object.keys(gatwaysToPublish))];

    // await Promise.all(
    //   keys.map(async key => {
    //     return publishGatewayGroups(actionType.UPDATED, {
    //       ids: gatwaysToPublish[key],
    //       gg_id: key
    //     })
    //   })
    // );

    return service;
  }

  return Service;
};
