'use strict';
module.exports = (sequelize, DataTypes) => {
  const ServiceGroup = sequelize.define(
    'ServiceGroup',
    {
      name: DataTypes.STRING,
      description: DataTypes.TEXT
    },
    {}
  );

  ServiceGroup.addScope('getAll', () => {
    const models = require('../models');
    return {
      attributes: [
        'id',
        'name',
        [
          models.sequelize.fn(
            'count',
            models.sequelize.col('GroupServices.groupId')
          ),
          'serviceCount'
        ],
        'updatedAt',
        'description'
      ],
      include: [
        {
          model: models.GroupService,
          attributes: []
        }
      ],
      group: ['ServiceGroup.id'],
      where: { },
      order: [[models.sequelize.literal('serviceCount'), 'DESC']]
    };
  });
  ServiceGroup.associate = function(models) {
    // associations can be defined here
    ServiceGroup.belongsToMany(models.Service, {
      through: 'GroupService',
      foreignKey: 'groupId'
    });

    ServiceGroup.belongsToMany(models.Entitlements, {
      through: models.ServiceGroupPolicies,
      foreignKey: 'service_group_id'
    });

    ServiceGroup.belongsToMany(models.DevicePolicies, {
      through: models.ServiceGroupDevicePolicies,
      foreignKey: 'service_group_id'
    });

    ServiceGroup.belongsToMany(models.RoutingPolicies, {
      through: models.ServiceGroupRoutingPolicies,
      foreignKey: 'service_group_id'
    });

    ServiceGroup.belongsToMany(models.SoftwarePolicies, {
      through: models.ServiceGroupSoftwarePolicies,
      foreignKey: 'service_group_id'
    });

    ServiceGroup.hasMany(models.GroupService, { foreignKey: 'groupId' });
  };

  return ServiceGroup;
};
