'use strict';
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Settings', {
    smtp_service: DataTypes.STRING,
    smtp_user: DataTypes.STRING,
    smtp_password: DataTypes.STRING,
    smtp_from: DataTypes.STRING,
    package_link_expiry: DataTypes.INTEGER,
    session_expiry: DataTypes.INTEGER,
    purge_allowed: DataTypes.BOOLEAN,
    saas_allowed: DataTypes.BOOLEAN,
    isSettingsSet: DataTypes.BOOLEAN,
    last_purge_date: DataTypes.DATE,
    auto_purge_days: DataTypes.INTEGER,
    date_format: DataTypes.STRING,
    gapiKey: DataTypes.STRING,
    password_expiry_days: DataTypes.INTEGER,
    smtp_host: DataTypes.STRING,
    smtp_port: DataTypes.INTEGER,
    isFirstLogin: DataTypes.BOOLEAN,
    mfa_server: DataTypes.STRING,
    biometrics_state: DataTypes.BOOLEAN,
    dirsync_enabled: DataTypes.BOOLEAN,
    core_auto_update: DataTypes.BOOLEAN,
    dirsync_time: DataTypes.INTEGER,
    dirclean_time: DataTypes.INTEGER,
    is_ldap_syncing: DataTypes.BOOLEAN,
    last_ldap_sync_start_time: DataTypes.DATE,
    last_ldap_sync_end_time: DataTypes.DATE,
    admin_mfa: DataTypes.BOOLEAN,
    max_clients: DataTypes.INTEGER,
    siem_host: DataTypes.STRING,
    siem_port: DataTypes.INTEGER,
    siem_protocol: DataTypes.STRING,
    health_status: DataTypes.INTEGER,
    services_access_logs: DataTypes.INTEGER,
    load_stats: DataTypes.INTEGER,
    device_validation_freq: {
      type: DataTypes.INTEGER,
      defaultValue: 1
    },
    in_activity_timeout: {
      type: DataTypes.INTEGER,
      defaultValue: 1
    },
    mtls_frequency: {
      type: DataTypes.INTEGER,
      defaultValue: 1
    },
    mtls_blocking_timeout: {
      type: DataTypes.INTEGER,
      defaultValue: 1
    },
    health_interval: {
      type: DataTypes.INTEGER,
      defaultValue: 1
    },
    load_stats_interval: {
      type: DataTypes.INTEGER,
      defaultValue: 1
    },
  });
};
