'use strict';
const moment = require('moment');

module.exports = function(sequelize, DataTypes) {
  var ServerStatus = sequelize.define('ServerStatus', {
    mfa_heartbeart_sent_at: DataTypes.DATE,
    onboarding_heartbeat_sent_at: DataTypes.DATE,
    isMfaServerOnline: {
      type: new DataTypes.VIRTUAL(DataTypes.BOOLEAN, [
        'mfa_heartbeart_sent_at'
      ]),
      get: function() {
        let allowedTimeInUtc = moment().subtract(120, 'seconds');
        const diffInSeconds = moment(this.get('mfa_heartbeart_sent_at'))
          .utc()
          .diff(allowedTimeInUtc, 'second');
        const v = this.get('mfa_heartbeart_sent_at');
        return diffInSeconds >= 0 ? true : false;
      }
    },
    isOnboardingServerOnline: {
        type: new DataTypes.VIRTUAL(DataTypes.BOOLEAN, [
          'onboarding_heartbeat_sent_at'
        ]),
        get: function() {
          let allowedTimeInUtc = moment().subtract(120, 'seconds');
          const diffInSeconds = moment(this.get('onboarding_heartbeat_sent_at'))
            .utc()
            .diff(allowedTimeInUtc, 'second');
          return diffInSeconds >= 0 ? true : false;
        }
      },
      createdAt: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.fn('now')
      },
      updatedAt: {
        type: DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize.fn('now')
      },
  }, {
    freezeTableName: true
  });
  return ServerStatus;
};
