'use strict';

const fs = require('fs-extra');

module.exports = function(sequelize, DataTypes) {
  const update = sequelize.define('Update', {
    buildOs: {
      type: DataTypes.ENUM(
        'ubuntu',
        'windows10',
        'windows',
        'macintosh',
        'ubuntuserver',
        'ubuntu18',
        'ubuntuserver18',
        'ios',
        'android',
        'windowsserver',
        'ubuntuserver20armv8',
        'centosserver'
      ),
      allowNull: false,
      defaultValue: 'ubuntu'
    },
    buildVersion: {
      type: DataTypes.STRING,
      allowNull: false
    },
    buildPath: {
      type: DataTypes.STRING,
      allowNull: false
    },
    buildComponent: {
      type: DataTypes.ENUM('client', 'controller', 'gateway'),
      allowNull: false
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false
    },
    buildFileSignature: DataTypes.TEXT,
    buildFileHash: DataTypes.STRING,
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.fn('now')
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.fn('now')
    },
    isDeleted: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false
    },
    is_settings_changed: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false
    }
  });

  update.addHook('afterCreate',updateServerBridges);

  update.addHook('afterUpdate',updateServerBridges);


  async function updateServerBridges(update,options){
    if(update.buildOs === 'ubuntuserver18'){
      await fs.emptyDir('/var/local/installers/serverBridges/');
    }
  }

  return update;
};
