const express = require('express');
const router = express.Router();
const clientController = require('../../dao/client.js');
const clientValidators = require('../../validators/clients');
const validate = require('../../validators/validate');
const {withLdapAuth} = require('../../middlewares/with-ldap-auth.js');
const validateSession = require('../../middlewares/validateSession.js');

router.post('/bridge/detail', withLdapAuth, clientController.getBridgeClientDetail);
router.post('/bridge/slaveDetail', clientController.getBridgeSlaveClientDetail);
router.post('/bridge/resetPasswordRequest', clientController.requestRestPassword);
router.post('/bridge/resetPassword', clientController.RestPassword);
router.get('/verify/otp', clientController.verifyOtp);
router.put('/riskScore', validateSession, clientValidators.updateClientRiskScore(), validate, clientController.updateClientRiskScore);
router.put('/event', validateSession, clientValidators.updateClientEvent(), validate, clientController.updateClientEvent);

module.exports = router;