var express = require('express');
var router = express.Router();
var models = require('../../models');
var path = require('path');
var url = require('url');
var http = require('http');
var https = require('https');
var archiver = require('archiver');
var projectConfig = require('../../config/config')['project'][process.env.NODE_ENV];
var appDir = path.dirname(require.main.filename);
let language = require('./../common/language');

//Creating my own logic here
var xmlbuilder = require('xmlbuilder');
var xmlcrypto = require('xml-crypto');
var xmldom = require('xmldom');
var xmlenc = require('xml-encryption');
var zlib = require('zlib');
var SignedXml = require('xml-crypto').SignedXml;
var crypto = require('crypto');
var fs = require('fs');
var querystring = require('querystring');
// const curl = new (require('curl-request'))();
const moment = require('moment');
//For LDAP
const ldapjs = require('ldapjs');
const PromiseBlueBird = require('bluebird');

let installerTypeMeta = {
    ubuntu: 'linux64-16',
    windows: 'win64',
    macintosh: 'mac',
    ios: 'ios',
    android: 'android',
    ubuntuserver: 'linux64-d-16',
    ubuntu18: 'linux64-18',
    ubuntuserver18: 'linux64-d-18'
};

let XMLNS = {
    SAML: 'urn:oasis:names:tc:SAML:2.0:assertion',
    SAMLP: 'urn:oasis:names:tc:SAML:2.0:protocol',
    MD: 'urn:oasis:names:tc:SAML:2.0:metadata',
    DS: 'http://www.w3.org/2000/09/xmldsig#',
    XENC: 'http://www.w3.org/2001/04/xmlenc#',
    EXC_C14N: 'http://www.w3.org/2001/10/xml-exc-c14n#',
    xsi: 'http://www.w3.org/2001/XMLSchema-instance',
    xs: 'http://www.w3.org/2001/XMLSchema',
    assertionFormatTrans: 'urn:oasis:names:tc:SAML:2.0:nameid-format:transient',
    username: 'urn:oasis:names:tc:SAML:2.0:attrname-format:basic',
    xsi_type: 'xs:string',
    methods: 'urn:oasis:names:tc:SAML:2.0:cm:bearer',
    password: 'urn:oasis:names:tc:SAML:2.0:ac:classes:Password',
    assertionFormatEmail:
        'urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress',
    assertionFormatUnSpecified:
        'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    assertionFormatPersistent:
        'urn:oasis:names:tc:SAML:2.0:nameid-format:persistent'
};

router.get('/saml/consume/', function (req, res, next) {
    crypto.randomBytes(20, function (err, buffer) {
        let token = buffer.toString('hex');
        var Saml = req.query.SAMLRequest;
        if (Saml != null && Saml !== '') {
            var gauthObj = {
                token: token,
                data: req.query.SAMLRequest,
                relay: req.query.RelayState,
                access_time_in_minutes: 5
            };
            models.Gauth.create(gauthObj).then(function (data) {
                var xml = new Buffer(
                    decodeURIComponent(req.query.SAMLRequest),
                    'base64'
                );
                zlib.inflateRaw(xml, function (err, inflated) {
                    res.redirect(projectConfig.offPremUiUrl + '/gauth/' + data.token);
                });
            });
        }
    });
});

router.get('/saml/consumeret/', function (req, res, next) {
    crypto.randomBytes(20, function (err, buffer) {
        const currentTimestamp = Date.now();
        let token = buffer.toString('hex');
        var Saml = req.query.SAMLRequest;
        if (Saml != null && Saml !== '') {
            var gauthObj = {
                token: token,
                data: req.query.SAMLRequest,
                relay: req.query.RelayState,
                access_time_in_minutes: 5,
                is_used: false,
                session_start_time: currentTimestamp
            };
            models.Gauth.create(gauthObj)
                .then(function (data) {
                    res.json({status: true, token: data.token, message: 'success'});
                })
                .catch(error => {
                    res.json({status: false, message: error, token: null});
                });
        }
    });
});

router.get('/saml/consume/logout', function (req, res, next) {
    res.redirect('https://gmail.com');
});

// Endpoint to retrieve metadata
router.get('/metadata.xml', function (req, res) {
    res.type('application/xml');
    let xml = `<?xml version="1.0"?>
                <md:EntityDescriptor xmlns:md="urn:oasis:names:tc:SAML:2.0:metadata" validUntil="2018-10-12T05:22:30Z" cacheDuration="PT1539753750S" entityID="ebryx.com">
                <md:IDPSSODescriptor WantAuthnRequestsSigned="false" protocolSupportEnumeration="urn:oasis:names:tc:SAML:2.0:protocol">
                <md:KeyDescriptor use="signing">
                <ds:KeyInfo xmlns:ds="http://www.w3.org/2000/09/xmldsig#">
                <ds:X509Data>
                <ds:X509Certificate>
                MIIDSTCCAjCgAwIBAgIBADANBgkqhkiG9w0BAQ0FADA+MQswCQYDVQQGEwJ1czEPMA0GA1UECAwGUHVuamFiMQ4wDAYDVQQKDAVFYnJ5eDEOMAwGA1UEAwwFRWJyeXgwHhcNMTgxMDA5MTA1NjM0WhcNMTkxMDA5MTA1NjM0WjA+MQswCQYDVQQGEwJ1czEPMA0GA1UECAwGUHVuamFiMQ4wDAYDVQQKDAVFYnJ5eDEOMAwGA1UEAwwFRWJyeXgwggEjMA0GCSqGSIb3DQEBAQUAA4IBEAAwggELAoIBAgDOk9DuDFr23i0Td4levbXpPK6LfIC8l5JEkTFcaxeTfdwpzN1iaudYO4D3p0I+CMmZ32/sKiZZR48Vgl+tyAX7rgo0riiCdeiA9GHSRmF7ehPK2+6uYbDI4Te5rNJQwJLBEZaazu5KQxsL0KJOlH+nzTLhNYELAMGJMJakO41uuP1XTRd8XLNK1VHU2aLZCO1k7I7BL2LALCdXyr8/dOt5MJDxGd8DLPZr3vIrcBLIrjlelfh9yn4z/Cl4n5VMX2EH3ggm7US4fWd4DLwUIq2afk5ZqqBnZ7YnFsASBPb8pWuixFfOTqAykW4ua+gkadQjRemqQRm4ZScS0KX2NQN8uwIDAQABo1AwTjAdBgNVHQ4EFgQUlgythEdfn+3/VVxuknlxjjP6h0kwHwYDVR0jBBgwFoAUlgythEdfn+3/VVxuknlxjjP6h0kwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOCAQIAMljgYh6BKaG2fqa6F2Yby6LV9Io8xW4TY/8bCy0QgK9R2J4hpgrSOLLId1PAI5FmB65nmMtVth6W4Yiy6ugsMwjUGLfsrj3nGaW5Ub/VBsqlZhP0L8tpits8zi+8WNDV5RiObgmODtlQ+cMxo+BXdDkgWhxGIX+TkagO6e6dVdHrX8M6F2tSFbASnuWpRUWZLTLFDLlJQh0X/4TeaYK6Z6EnD4m8+dYJeX+8wJXv0XjXNykOplHqfjY7nVBpRfBazUQGUti+/XrDY2f124THk8AEn59VWZinMsyA+it2I/u368AJf10lYL9HJnUk63vlzOnzB/0GJM6/GqNcEeR0wK8=
                </ds:X509Certificate>
                </ds:X509Data>
                </ds:KeyInfo>
                </md:KeyDescriptor>
                <md:KeyDescriptor use="encryption">
                <ds:KeyInfo xmlns:ds="http://www.w3.org/2000/09/xmldsig#">
                <ds:X509Data>
                <ds:X509Certificate>
                MIIDSTCCAjCgAwIBAgIBADANBgkqhkiG9w0BAQ0FADA+MQswCQYDVQQGEwJ1czEPMA0GA1UECAwGUHVuamFiMQ4wDAYDVQQKDAVFYnJ5eDEOMAwGA1UEAwwFRWJyeXgwHhcNMTgxMDA5MTA1NjM0WhcNMTkxMDA5MTA1NjM0WjA+MQswCQYDVQQGEwJ1czEPMA0GA1UECAwGUHVuamFiMQ4wDAYDVQQKDAVFYnJ5eDEOMAwGA1UEAwwFRWJyeXgwggEjMA0GCSqGSIb3DQEBAQUAA4IBEAAwggELAoIBAgDOk9DuDFr23i0Td4levbXpPK6LfIC8l5JEkTFcaxeTfdwpzN1iaudYO4D3p0I+CMmZ32/sKiZZR48Vgl+tyAX7rgo0riiCdeiA9GHSRmF7ehPK2+6uYbDI4Te5rNJQwJLBEZaazu5KQxsL0KJOlH+nzTLhNYELAMGJMJakO41uuP1XTRd8XLNK1VHU2aLZCO1k7I7BL2LALCdXyr8/dOt5MJDxGd8DLPZr3vIrcBLIrjlelfh9yn4z/Cl4n5VMX2EH3ggm7US4fWd4DLwUIq2afk5ZqqBnZ7YnFsASBPb8pWuixFfOTqAykW4ua+gkadQjRemqQRm4ZScS0KX2NQN8uwIDAQABo1AwTjAdBgNVHQ4EFgQUlgythEdfn+3/VVxuknlxjjP6h0kwHwYDVR0jBBgwFoAUlgythEdfn+3/VVxuknlxjjP6h0kwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQ0FAAOCAQIAMljgYh6BKaG2fqa6F2Yby6LV9Io8xW4TY/8bCy0QgK9R2J4hpgrSOLLId1PAI5FmB65nmMtVth6W4Yiy6ugsMwjUGLfsrj3nGaW5Ub/VBsqlZhP0L8tpits8zi+8WNDV5RiObgmODtlQ+cMxo+BXdDkgWhxGIX+TkagO6e6dVdHrX8M6F2tSFbASnuWpRUWZLTLFDLlJQh0X/4TeaYK6Z6EnD4m8+dYJeX+8wJXv0XjXNykOplHqfjY7nVBpRfBazUQGUti+/XrDY2f124THk8AEn59VWZinMsyA+it2I/u368AJf10lYL9HJnUk63vlzOnzB/0GJM6/GqNcEeR0wK8=
                </ds:X509Certificate>
                </ds:X509Data>
                </ds:KeyInfo>
                </md:KeyDescriptor>
                <md:SingleLogoutService Binding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect" Location="https://172.16.15.111:8080/api/gauth/saml/consume"/>
                <md:NameIDFormat>
                urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified
                </md:NameIDFormat>
                <md:SingleSignOnService Binding="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect" Location="https://172.16.15.111:8080/api/gauth/saml/consume"/>
                </md:IDPSSODescriptor>
                </md:EntityDescriptor>`;
    res.send(xml);
});

router.post('/validate/', async function (req, res, next) {
    const currentTimestamp = Date.now();

    let response = req.body;
    let token = response.token;
    let agentId = response.agentId;
    let encryptedSecret = response.secret;
    let encryptedTimestamp = response.timestamp;
    let audience = '';
    let destination = '';

    const client = await models.Client.findOne({
        where: {
            agent_id: agentId
        }
    });

    if (!client) { 
        res.json({
            status: false,
            message: 'Incorrect client data provided.'
        });
    }
    
    const sharedSecret = client.shared_secret;
    const algo = 'aes-256-cbc';

    const encryptionKey = crypto.createHash('sha256').update(sharedSecret).digest('hex');
    const md5IV = crypto.createHash('md5').update(sharedSecret).digest('hex');
    
    // decrypt timestamp:
    const timestampKey = encryptionKey.substring(0, 32);
    const timestampIV = md5IV.substring(md5IV.length - 16, md5IV.length);

    const decipherTimestamp = crypto.createDecipheriv(algo, timestampKey, timestampIV);
    let decryptedtimestamp = decipherTimestamp.update(encryptedTimestamp, 'hex', 'utf8');
    decryptedtimestamp += decipherTimestamp.final('utf8'); // decypted timestamp

    // Convert the decrypted timestamp string to unix timestamp
    const clientTimestamp = parseInt(decryptedtimestamp, 10);

    // decrypt secret:
    const secretKey = encryptionKey.substring(0, 24) + decryptedtimestamp.substring(decryptedtimestamp.length - 8); // first 24 shared secret, ending 8 timestamp
    const secretIV = encryptionKey.substring(encryptionKey.length - 8) + decryptedtimestamp.substring(decryptedtimestamp.length - 8); // last 8 for both shared secret and timestamp

    const decipherSecret = crypto.createDecipheriv(algo, secretKey, secretIV);
    let decryptedSecret = decipherSecret.update(encryptedSecret, 'hex', 'utf8');
    decryptedSecret += decipherSecret.final('utf8'); // decypted secret

    models.Gauth.find({
        where: {
            token: token,
            is_used: false
        }
    })
        .then(function (foundOBJ) {
            if (foundOBJ) {
                var libxmljs = require('libxmljs');
                var Saml = foundOBJ.data;
                let sessionStartTime = foundOBJ.session_start_time;
                let fullId = decryptedSecret;

                if (fullId.split(',').length !== 2) {
                    res.json({
                        status: false,
                        message: 'Invalid response sent from client.'
                    });
                    return 0;
                }

                let seprateId = fullId.split(',');
                let deviceId = seprateId[0].split('=')[1];
                let username = seprateId[1].split('=')[1];
                let wholeUrl = projectConfig.offPremApiUrl.split('://')[1];
                let mainPartUrl = wholeUrl.split(':')[0];
                let tmainPort = wholeUrl.split(':')[1];
                let mainPort = tmainPort.split('/')[0];

                const timeToLive = 7000; // in milliseconds
                if (
                  sessionStartTime - timeToLive > clientTimestamp ||
                  currentTimestamp + timeToLive < clientTimestamp
                ) {
                    console.log("Invalid timestamp provided:");
                    console.log('sessionStartTime - timeToLive :>> ', sessionStartTime - timeToLive);
                    console.log('clientTimestamp :>> ', clientTimestamp);
                    console.log('currentTimestamp + timeToLive :>> ', currentTimestamp + timeToLive);
                    return res.json({
                        status: false,
                        message: 'Please check your system time.'
                    });
                }

                if (clientTimestamp > sessionStartTime + timeToLive) {
                    console.log("Client timestamp not falling in the allowed range:");
                    console.log('sessionStartTime :>> ', sessionStartTime);
                    console.log('clientTimestamp :>> ', clientTimestamp);
                    return res.json({
                        status: false,
                        message: 'Your SSO session has expired.'
                    });
                }
                
                mainPartUrl = 'localhost';
                var httpOptions = {
                    host: mainPartUrl,
                    path: '/api/gauth/sso-validate-user/',
                    method: 'POST',
                    port: mainPort,
                    rejectUnauthorized: false,
                    requestCert: true,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                };
                var postData = JSON.stringify({
                    user: username,
                    agentId: agentId,
                    deviceId: deviceId
                });


                var httpsReq = https.request(httpOptions, function (resPost) {
                    resPost.setEncoding('utf8');
                    resPost.on('data', function (body) {
                        body = JSON.parse(body);

                        if (body) {
                            if (Saml != null && Saml !== '') {
                                var xml = new Buffer(decodeURIComponent(Saml), 'base64');
                                zlib.inflateRaw(xml, function (err, inflated) {
                                    let saml_decoded = inflated || xml.toString('ascii');
                                    // Parse ID
                                    var xmlDoc = libxmljs.parseXml(saml_decoded);
                                    var idNode = xmlDoc.get('/samlp:AuthnRequest', {
                                        samlp: 'urn:oasis:names:tc:SAML:2.0:protocol',
                                        saml: 'urn:oasis:names:tc:SAML:2.0:assertion'
                                    });
                                    let email = 'test';
                                    let issuer_data_raw = idNode.text();
                                    let issuer_data = issuer_data_raw === 'urn:federation:MicrosoftOnline' ? 'Office365' : issuer_data_raw;
                                    models.Idp.findOne({
                                        where: { sp_id: issuer_data }
                                    }).then(function (idpOBJ) {
                                        if (idpOBJ) {
                                            destination = idpOBJ.assertion_url;
                                            audience = idpOBJ.sp_id;

                                            let in_response_to = idNode.attr('ID').value();
                                            let issuer = idpOBJ.e_id;
                                            let status = '';
                                            if (body.status !== false) {
                                                status = 'urn:oasis:names:tc:SAML:2.0:status:Success';
                                                email = (issuer_data === 'Office365' || issuer_data.includes('signin.aws.amazon')) ? body.username : body.email;
                                            } else {
                                                status =
                                                    'urn:oasis:names:tc:SAML:2.0:status:RequestDenied';
                                            }
                                            console.log('Email is ' + body.status);
                                                if (!body.username) {
                                                res.json({
                                                    status: false,
                                                    message: language.get['INVALID_EMAIL_PASSWORD']
                                                });
                                                return;
                                            }

                                            let time = new Date();
                                            time.setHours(time.getHours() + 24);
                                            let not_on_or_after = time.toISOString();

                                            time.setHours(time.getHours() - 48);
                                            let not_before = time.toISOString();

                                            let data = xmlbuilder
                                                .create(
                                                    {
                                                        'samlp:Response': {
                                                            '@Destination': destination,
                                                            '@ID':
                                                                '_' + crypto.randomBytes(21).toString('hex'),
                                                        '@InResponseTo': in_response_to,
                                                            '@IssueInstant': new Date().toISOString(),
                                                            '@Version': '2.0',
                                                            '@xmlns:samlp': XMLNS.SAMLP,
                                                            '@xmlns:saml': XMLNS.SAML,
                                                            'saml:Issuer': issuer,
                                                            'samlp:Status': {
                                                                'samlp:StatusCode': {'@Value': status}
                                                            },
                                                            'saml:Assertion': {
                                                                'saml:Issuer': issuer,
                                                                '@xmlns:xsi': XMLNS.xsi,
                                                                '@xmlns:xs': XMLNS.xs,
                                                                '@ID':
                                                                    '_' +
                                                                    crypto.randomBytes(21).toString('hex'),
                                                                '@IssueInstant': new Date().toISOString(),
                                                                '@Version': '2.0',
                                                                'saml:Subject': {
                                                                    'saml:NameID': {
                                                                        '@SPNameQualifier': destination,
                                                                        '@Format': XMLNS[issuer_data === 'Office365' ? 'assertionFormatPersistent' : 'assertionFormatEmail'],
                                                                        '#text': email
                                                                    },
                                                                    'saml:SubjectConfirmation': {
                                                                        '@Method': XMLNS.methods,
                                                                        'saml:SubjectConfirmationData': {
                                                                            '@NotOnOrAfter': not_on_or_after,
                                                                            '@Recipient': destination,
                                                                            '@InResponseTo': in_response_to
                                                                        }
                                                                    }
                                                                },
                                                                'saml:Conditions': {
                                                                    '@NotOnOrAfter': not_on_or_after,
                                                                    '@NotBefore': not_before,
                                                                    'saml:AudienceRestriction': {
                                                                        'saml:Audience': audience
                                                                    }
                                                                },
                                                                'saml:AuthnStatement': {
                                                                    '@SessionNotOnOrAfter':
                                                                        not_on_or_after,
                                                                    '@AuthnInstant': new Date().toISOString(),
                                                                    '@SessionIndex':
                                                                        '_' +
                                                                        crypto.randomBytes(21).toString('hex'),
                                                                    'saml:AuthnContext': {
                                                                        'saml:AuthnContextClassRef':
                                                                        XMLNS.password
                                                                    }
                                                                },
                                                                'saml:AttributeStatement': {
                                                                    'saml:Attribute': {
                                                                        '@Name': 'username',
                                                                        '@NameFormat': XMLNS.username,
                                                                        'saml:AttributeValue': {
                                                                            '@xsi:type': XMLNS.xsi_type,
                                                                            '#text': body.username
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {headless: true}
                                                )
                                                .toString();
                                            //Signing Data
                                            let private_key = fs.readFileSync(
                                                process.env.SSO_PRIVATE_CERTIFICATE
                                            );
                                            let signer = new SignedXml();
                                            signer.addReference("//*[local-name(.)='Assertion']", [
                                                'http://www.w3.org/2000/09/xmldsig#enveloped-signature',
                                                'http://www.w3.org/2001/10/xml-exc-c14n#'
                                            ]);
                                            signer.signingKey = private_key;
                                            signer.computeSignature(data, {
                                                prefix: 'ds',
                                                location: {
                                                    reference: "//*[local-name(.)='Subject']",
                                                    action: 'before'
                                                }
                                            });
                                            let signedXML = signer.getSignedXml();

                                            var cert = fs.readFileSync(
                                                process.env.SSO_PUBLIC_CERTIFICATE,
                                                'utf8'
                                            );
                                            cert = cert.replace('-----BEGIN CERTIFICATE-----', '');
                                            cert = cert.replace('-----END CERTIFICATE-----', '');
                                            cert = cert.replace(/\n/g, '');
                                            signedXML = signedXML.replace(
                                                '</ds:SignatureValue>',
                                                '</ds:SignatureValue><ds:KeyInfo><ds:X509Data><ds:X509Certificate>' +
                                                cert +
                                                '</ds:X509Certificate></ds:X509Data></ds:KeyInfo>'
                                            );

                                            data = new Buffer(signedXML).toString('base64');
                                            foundOBJ.is_used = true;
                                            foundOBJ.save();
                                            res.json({
                                                data: data,
                                                relay: foundOBJ.relay,
                                                status: true,
                                                destination: destination
                                            });
                                        } //if idpOBJ
                                    });
                                });
                            }
                        } else {
                            res.json({status: false});
                        }
                    });
                });
                httpsReq.write(postData);
                httpsReq.end();

            } else {
                res.json({status: false, message: language.get['TOKEN_INVALID']});
            }
        })
        .catch(error => {
            console.log(error && (error.message || error));
            res.json({status: false, message: language.get['TOKEN_INVALID']});
        });
});

router.post('/onboard/', function (req, res, next) {
    let response = req.body;
    let token = response.token;
    let clientToken = response.clientToken;
    models.Gauth.find({
        where: {
            token: token
        }
    })
        .then(function (foundOBJ) {
            console.log('Object found')
            if (foundOBJ) {
                var Saml = foundOBJ.data;
                let wholeUrl = projectConfig.offPremApiUrl.split('://')[1];
                let tmainPort = wholeUrl.split(':')[1];
                let mainPort = tmainPort.split('/')[0];
                let mainPartUrl = 'localhost';
                var httpOptions = {
                    host: mainPartUrl,
                    path: '/api/gauth/onboard-validate-user/',
                    method: 'POST',
                    port: mainPort,
                    rejectUnauthorized: false,
                    requestCert: true,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                };
                var postData = JSON.stringify({
                    user: response.username,
                    pass: response.password
                });
                var httpsReq = https.request(httpOptions, function (resPost) {
                    console.log('Making Request');
                    resPost.setEncoding('utf8');
                    resPost.on('data', function (body) {
                        body = JSON.parse(body);
                        if (body) {
                            if (Saml != null && Saml !== '' && body.status) {
                                models.Client.find({
                                    where: {
                                        id: clientToken
                                    }
                                })
                                    .then(function (client) {
                                        if (client) {
                                            const linkExpiry = moment.tz(
                                                client.link_key_expiry,
                                                moment.tz.guess()
                                            );
                                            if (client.isDeviceIdSet === false) {
                                                if (moment().isBefore(linkExpiry)) {
                                                    models.DownloadPackage.find({
                                                        where: {client_id: client.id, used: 0},
                                                        limit: 1,
                                                        order: [['id', 'DESC']]
                                                    })
                                                        .then(function (DP) {
                                                            if (DP) {
                                                                res.json({
                                                                    status: true,
                                                                    onPremDLink: prepareOnPremiseDownloadLink(
                                                                        client.device_os,
                                                                        client.link_key
                                                                    ),
                                                                    offPremDLink: prepareOffPremiseDownloadLink(
                                                                        client.device_os,
                                                                        client.link_key
                                                                    ),
                                                                    onPremDevLink: prepareOnPremiseDeviceIdLink(
                                                                        client.device_os,
                                                                        DP.link_key
                                                                    ),
                                                                    offPremDevLink: prepareOffPremiseDeviceIdLink(
                                                                        client.device_os,
                                                                        DP.link_key
                                                                    )
                                                                });
                                                            } else {
                                                                res.json({
                                                                    status: false,
                                                                    message: 'Package not found.'
                                                                });
                                                            }
                                                        })
                                                        .catch(err => {
                                                            res.json({
                                                                status: false,
                                                                message: 'Package not found.'
                                                            });
                                                        });
                                                } else {
                                                    res.json({
                                                        status: false,
                                                        message: 'Client link has been expired.'
                                                    });
                                                }
                                            } else {
                                                res.json({
                                                    status: false,
                                                    message: 'Kindly Log into your client and try again.'
                                                });
                                            }
                                        } else {
                                            res.json({
                                                status: false,
                                                message: 'Invalid client token.'
                                            });
                                        }
                                    })
                                    .catch(error => {
                                        console.log(error && (error.message || error));
                                        res.json({
                                            status: false,
                                            message: 'Invalid client token.'
                                        });
                                    });
                            } else {
                                res.json(body);
                            }
                        } else {
                            res.json({status: false});
                        }
                    });
                });
                httpsReq.write(postData);
                httpsReq.end();
            } else {
                res.json({status: false, message: language.get['TOKEN_INVALID']});
            }
        })
        .catch(error => {
            console.log(error && (error.message || error));
            res.json({status: false, message: language.get['TOKEN_INVALID']});
        });
});

function prepareOnPremiseDownloadLink(clientOs, key) {
    let emailLink;

    if (clientOs === installerTypeMeta['android']) {
        emailLink =
            `http://www.sdpclient.com?url=${projectConfig.onPremApiUrl}/clients/download/service/` +
            new Buffer(key).toString('base64');
    } else if (clientOs === installerTypeMeta['ios']) {
        emailLink =
            `sdpclient://?url=${projectConfig.onPremApiUrl}/clients/download/service/` +
            new Buffer(key).toString('base64');
    } else {
        emailLink =
            `${projectConfig.onPremApiUrl}/clients/download/service/` +
            new Buffer(key).toString('base64');
    }

    return emailLink;
}

function prepareOffPremiseDownloadLink(clientOs, key) {
    let emailLink;

    if (clientOs === installerTypeMeta['android']) {
        emailLink =
            `http://www.sdpclient.com?url=${projectConfig.offPremApiUrl}/clients/download/service/` +
            new Buffer(key).toString('base64');
    } else if (clientOs === installerTypeMeta['ios']) {
        emailLink =
            `sdpclient://?url=${projectConfig.offPremApiUrl}/clients/download/service/` +
            new Buffer(key).toString('base64');
    } else {
        emailLink =
            `${projectConfig.offPremApiUrl}/clients/download/service/` +
            new Buffer(key).toString('base64');
    }

    return emailLink;
}

function prepareOnPremiseDeviceIdLink(clientOs, key) {
    return `${projectConfig.onPremApiUrl}/deviceid/add/` + key;
}

function prepareOffPremiseDeviceIdLink(clientOs, key) {
    return `${projectConfig.offPremApiUrl}/deviceid/add/` + key;
}

router.post('/sso-validate-user/', async function (req, response, next) {

    let res = req.body;
    let username = res.user;
    let agentId = res.agentId;
    let deviceId = res.deviceId;

    try {

        const status = {
            isLocalUserFound: true,
            isClientFound: false,
            isLdapFound: true,
            message: ''
        };


        const client = await models.Client.findOne({
            where: {
                agent_id: agentId,
                user: username
            }
        });

        if (client) {
            status.isClientFound = true;
            if (client.device_hardware_id === deviceId) {
                return response.json({
                    status: true,
                    email: client.Email,
                    username: client.user
                });
            } else {
                status.isClientFound = false;
                status.message = 'Invalid device id.';
            }

        } else {
            status.isClientFound = false;
            status.message = 'Invalid Agent id or username.';
        }


    } catch (error) {
        console.log(error && (error.message || error));
        response.json({status: false, message: language.get['TOKEN_INVALID']});
    }
});

router.post('/onboard-validate-user/', function (req, response, next) {
    let res = req.body;
    var username = res.user;
    var password = res.pass;
    models.Ldap.findOne({
        where: { }
    })
        .then(function (ldap) {
            var ldapOptions = {
                url: ldap.LDAP_url,
                timeout: ldap.LDAP_timeout,
                connectTimeout: ldap.LDAP_connectTimeout,
                reconnect: true
            };

            var uri = ldap.LDAP_url;
            var urlparts = uri.split('//');
            var protocol = urlparts[0];
            var ipandport = urlparts[1];
            var seprateipandport = ipandport.split(':');

            if (protocol == 'ldaps:') {
                var tlsOptions = {
                    cert: ldap.LDAP_cert,
                    ca: ldap.LDAP_ca
                };
                ldapOptions.tlsOptions = tlsOptions;
            }
            console.log('---------ldapOptions-------', ldapOptions);

            return new PromiseBlueBird((resolve, reject) => {
                const ldapClient = ldapjs.createClient(ldapOptions);
                //Checking if LDAP is accessable
                const {exec} = require('child_process');
                exec(
                    'telnet ' +
                    seprateipandport[0] +
                    ' ' +
                    seprateipandport[1] +
                    ' | echo "Connect"',
                    (err, stdout, stderr) => {
                        if (err) {
                            // NODE couldn't execute the command
                            response.json({
                                status: false,
                                message: language.get['HOST_NOT_FOUND']
                            });
                            return;
                        }
                        if (stderr) {
                            response.json({
                                status: false,
                                message: language.get['HOST_NOT_FOUND']
                            });
                            return;
                        } else {
                            var user = '';
                            var userSeparators = '';
                            if (ldap.LDAP_user.includes('uid')) {
                                user = 'uid=' + username;
                                userSeparators = ldap.LDAP_user.split(',');
                                for (var i = 1; i < userSeparators.length; i++) {
                                    user = user + ',' + userSeparators[i];
                                }
                            } else {
                                userSeparators = ldap.LDAP_user.split('@');
                                user = username + '@' + userSeparators[1];
                            }
                            if (stdout.indexOf('refused') === -1) {
                                ldapClient.bind(
                                    //'uid=' + username + ',cn=users,cn=accounts,dc=ebryx,dc=local',
                                    user,
                                    password,
                                    err => {
                                        if (err) {
                                            if (err instanceof ldapjs.InvalidCredentialsError) {
                                                response.json({
                                                    status: false,
                                                    message: 'Invalid Credentials.'
                                                });
                                                return;
                                            } else if (
                                                err instanceof ldapjs.InappropriateAuthenticationError
                                            ) {
                                                response.json({
                                                    status: false,
                                                    message: 'Inappropriate Authentication Error.'
                                                });
                                                return;
                                            } else {
                                                response.json({status: false});
                                                return;
                                            }
                                        }

                                        let options = {
                                            attributes: ['uid'],
                                            scope: 'sub',
                                            filter: '(&(objectClass=person)(uid=' + username + '))'
                                        };

                                        ldapClient.search(ldap.LDAP_dc, options, (err, res) => {
                                            if (err) return reject(err);
                                            let entries = [];
                                            res.on('searchEntry', function (entry) {
                                                var r = entry.object;
                                                entries.push(r);
                                            });

                                            res.on('error', function (err) {
                                                reject(err);
                                            });

                                            res.on('end', function (result) {
                                                response.json({status: true});
                                            });
                                        });
                                    }
                                );
                            } else {
                                response.json({
                                    status: false,
                                    message: language.get['HOST_NOT_FOUND']
                                });
                            }
                        }
                    }
                );
            });
        })
        .catch(error => {
            console.log(error && (error.message || error));
            response.json({status: false, message: language.get['TOKEN_INVALID']});
        });
});

module.exports = router;
