var express = require('express');
var router = express.Router();
var models = require('../../models');
let language = require('./../common/language');
const validatePassword = require('../../middlewares/validatePassword');
const idpValidations = require('../../validators/idps');
var validate = require('../../validators/validate');

const {
  deleteIdp,
  addIdp,
  getIdp,
  udpateIdp,
  getIdps
} = require('../../dao/idps');

/* GET idps listing. */
router.get('/', getIdps);

/* GET update idp. */
router.put('/:id', idpValidations.updateIdp(), validate, udpateIdp);

/* Get a single idp detail */
router.get('/:id', getIdp);

// add new idp
router.post('/', idpValidations.addIdp(), validate, addIdp);

// delete a single idp
router.delete('/:id', validatePassword, idpValidations.deleteIdp(), validate, deleteIdp);

module.exports = router;
