const client = require('../../config/cache');

const actionType = {
    ADDED: 0,
    UPDATED: 1,
    DELETED: 2
}

const channel = {
    CLIENTS: 'Clients',
};

const messageType = {
    CLIENTS: 'Clients',
}

const publishClients = eventFactory(channel.CLIENTS, messageType.CLIENTS);

function eventFactory(_channel, _msg_type){
    return (event, message) => {
        let obj = {
            ...message,
            event
        };
        
        if(!([
            messageType.NEWSOFTWARE, messageType.UPDATESOFTWARE, messageType.REMOVESOFTWARE
        ].includes(_msg_type))) {
            obj = {
                ...obj, 
                msg_type: _msg_type
            };
        }
    
        const _message = JSON.stringify(obj);
        console.log('sending pub sub', _channel, _message)
        return client.publishAsync(_channel, _message);
    }
}

module.exports = {
    publishClients,
    actionType
};
