const detectInjection = (inputStr, req) => {
    if(typeof inputStr == 'object') {
        return detectInjection(JSON.stringify(inputStr), req);
    }
    else if(typeof inputStr == 'string' || typeof str == 'number') {
        return req.sanitize(inputStr);
    }
}

module.exports = {
    inspectInjection: (req, res, next) => {
        try{
            if(req.body) {
                for(let key in req.body) {
                    req.body[key] = detectInjection(req.body[key], req);
                }
            }
            if(req.headers) {
                for(let key in req.headers) {
                    req.headers[key] = detectInjection(req.headers[key], req);
                }
            }
            if(req.query) {
                for(let key in req.query) {
                    req.query[key] = detectInjection(req.query[key], req);
                }
            }
            if(req.params) {
                for(let key in req.params) {
                    req.params[key] = detectInjection(req.params[key], req);
                }
            }
            
            next();
        }
        catch(err) {
            next(err);
        }
    }
}
