const fs = require("fs");
const express = require('express');
const router = express.Router();

router.get('/', function(req, res, next) {
    var data = fs.readFileSync('./models/general/.version').toString().split("\n");
    if(data.length > 0){
      res.render('home', {
        major_release: data[0].replace(/\D/g,''),
        minor_release: data[1].replace(/\D/g,''),
        patch_number: data[2].replace(/\D/g,''),
        build_number: data[3].replace(/\D/g,'')
     });
    }else{
      res.render('home', {
        major_release: '',
        minor_release: '',
        patch_number: '',
        build_number: ''
     });
    }
});

router.get('/version', function(req, res, next) {
    try {
      var data = fs.readFileSync('./models/general/.version').toString().split("\n");
      if(data.length > 0){
        data ={
          major_release: data[0].replace(/\D/g,''),
          minor_release: data[1].replace(/\D/g,''),
          patch_number: data[2].replace(/\D/g,''),
          build_number: data[3].replace(/\D/g,'')
      };
      res.status(200).json(data);
      }else{
        data = {
          major_release: '',
          minor_release: '',
          patch_number: '',
          build_number: ''
      };
      res.status(200).json(data);
      }
    }
    catch (e) {
      res.status(500).json(JSON.stringify(e));
    }
});

module.exports = router;