const { body } = require('express-validator');

const updateClientRiskScore = () => [
    ...agentId(body),
    ...riskScore(body)
];

const updateClientEvent = () => [
    ...agentId(body),
    ...event(body)
];

const agentId = check => [
    check('agent_id')
    .exists()
    .not()
    .isEmpty()
    .isNumeric()
    .withMessage('agent_id is required.')
];

const riskScore = check => [
    check('risk_score')
    .exists()
    .not()
    .isEmpty()
    .isInt({min: 1, max: 10})
    .withMessage('Risk score must be an integer and ranges between 1 to 10.')
];

const event = check => [
    check('event')
    .exists()
    .not()
    .isEmpty()
    .isBoolean()
    .withMessage('Event must be a boolean value.')
];

module.exports = {
    updateClientRiskScore,
    updateClientEvent
}
