const { body, param } = require('express-validator');


const addIdp = () => {
    return [
        ...assertion_url(body),
        ...name(body),
        ...sp_id(body)
    ];
};


const updateIdp = () => {
    return [
        ...id(param),
        ...assertion_url(body),
        ...name(body),
        ...sp_id(body)
    ];
}


const deleteIdp = () => {
    return [
        ...id(param)
    ]
}


const assertion_url = check => [
    check('idp.assertion_url')
    .exists()
    .not()
    .isEmpty()
]


const name = check => [
    check('idp.name')
    .exists()
]


const sp_id = check => [
    check('idp.sp_id')
    .exists()
    .not()
    .isEmpty()
]


const id = check => [
    check('id')
    .exists()
    .not()
    .isEmpty()
    .isNumeric()
]


module.exports = {
    addIdp,
    updateIdp,
    deleteIdp
}