const {validationResult} = require('express-validator');
const httpErrors = require('http-errors');

module.exports = (req, res, next) => {
  const errors = validationResult(req);
  if (errors.isEmpty()) {
    return next();
  }
  const extractedErrors = errors.array().map((err) => ({[err.param]: err.msg}));

  return next(new httpErrors.UnprocessableEntity(extractedErrors));
};